/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.game.event;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import xyz.noark.core.event.DelayEvent;
import xyz.noark.core.event.Event;
import xyz.noark.game.event.DefaultEventManager;
import xyz.noark.game.event.FixedTimeEventWrapper;
import xyz.noark.game.event.ScheduledEvent;
import xyz.noark.game.event.ShutdownEvent;
import xyz.noark.log.LogHelper;

class DelayEventThread
extends Thread {
    private static final int SHUTDOWN_TIMEOUT = 1;
    private static final DelayQueue<DelayEvent> QUEUE = new DelayQueue();
    private final DefaultEventManager eventManager;
    private volatile boolean starting = true;

    public DelayEventThread(DefaultEventManager eventManager) {
        super("delay-event");
        this.eventManager = eventManager;
    }

    @Override
    public void run() {
        LogHelper.logger.info("\u5ef6\u8fdf\u4efb\u52a1\u8c03\u5ea6\u7ebf\u7a0b\u5f00\u59cb\u5566...");
        while (this.starting) {
            try {
                DelayEvent event = (DelayEvent)QUEUE.take();
                if (event instanceof ShutdownEvent) {
                    LogHelper.logger.info("\u5ef6\u8fdf\u4efb\u52a1\u8c03\u5ea6\u7ebf\u7a0b\u505c\u6b62\u5566...");
                    this.starting = false;
                    ((ShutdownEvent)event).countDown();
                    continue;
                }
                if (event instanceof ScheduledEvent) {
                    this.eventManager.notifyScheduledHandler((ScheduledEvent)event);
                    continue;
                }
                if (event instanceof FixedTimeEventWrapper) {
                    this.eventManager.notifyFixedTimeEventHandler((FixedTimeEventWrapper)event);
                    continue;
                }
                this.eventManager.notifyListeners((Event)event);
            }
            catch (Throwable e) {
                LogHelper.logger.error("\u8c03\u5ea6\u7ebf\u7a0b\u5f02\u5e38", new Object[]{e});
            }
        }
    }

    public boolean addDelayEvent(DelayEvent event) {
        return QUEUE.add(event);
    }

    public boolean remove(DelayEvent event) {
        return QUEUE.remove(event);
    }

    public void shutdown() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.addDelayEvent(new ShutdownEvent(countDownLatch));
        try {
            countDownLatch.await(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LogHelper.logger.warn("shutdown event exec exception. {}", new Object[]{e});
        }
    }
}

