/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.game.id;

import java.util.concurrent.atomic.AtomicInteger;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.game.id.IdMaxSequenceException;

public class IdGenerator {
    private static final long MAX_TIMES = 262144L;
    private static final long MAX_SEQUENCE = 0x2000000L;
    private final long sid;
    private final long times;
    private final AtomicInteger sequence = new AtomicInteger(0);

    public IdGenerator(int sid, int times) {
        this.sid = sid;
        this.times = times;
        if ((long)times >= 262144L) {
            throw new ServerBootstrapException("\u533a\u670d\u542f\u52a8\u5df2\u8fbe\u6700\u5927\u6b21\u6570\u4e86,\u4e5f\u5e94\u8be5\u5408\u670d\u4e86\u5427\uff0c\u5411\u540e\u5408\u5662... times=" + times);
        }
    }

    public long generateId() throws IdMaxSequenceException {
        return this.sid << 44 | this.times << 26 | this.nextSequence() << 1 | 1L;
    }

    private long nextSequence() throws IdMaxSequenceException {
        long result = this.sequence.incrementAndGet();
        if (result >= 0x2000000L) {
            throw new IdMaxSequenceException("\u81ea\u589e\u56e0\u5b50\u5df2\u8fbe\u6700\u5927\u503c,\u5305\u88c5\u751f\u6210\u5668\u8981\u81ea\u589e\u542f\u52a8\u6b21\u6570\u5566... sequence=" + result);
        }
        return result;
    }

    public String toString() {
        return "IdGenerator [sid=" + this.sid + ", times=" + this.times + ", sequence=" + this.sequence + "]";
    }
}

