/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.game.loader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import xyz.noark.core.util.ByteArrayUtils;
import xyz.noark.game.loader.scheme.SchemeManager;

public class NoarkClassLoader
extends ClassLoader {
    public NoarkClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassFormatError e) {
            return this.analysisFormatErrorClass(name);
        }
    }

    private Class<?> analysisFormatErrorClass(String name) throws ClassNotFoundException {
        byte[] bytes = this.loadBytesForClassName(name);
        int scheme = ByteArrayUtils.toInt((byte[])bytes);
        SchemeManager.getScheme(scheme).decode(bytes);
        return this.defineClass(name, bytes, 4, bytes.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] loadBytesForClassName(String name) throws ClassNotFoundException {
        try (InputStream is = this.openStreamForClass(name);){
            byte[] byArray = this.readInputStream(is);
            return byArray;
        }
        catch (Exception e) {
            throw new ClassNotFoundException("class not found exception. name=" + name);
        }
    }

    public byte[] readInputStream(InputStream is) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);){
            int i = is.read();
            while (i != -1) {
                baos.write(i);
                i = is.read();
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    protected InputStream openStreamForClass(String name) {
        String internalName = name.replace('.', '/') + ".class";
        return this.getResourceAsStream(internalName);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

