/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.game.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.game.loader.NoarkClassLoader;

public class NoarkManifest {
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String START_CLASS_KEY = "Start-Class";
    private final String startClass;

    public NoarkManifest(NoarkClassLoader classLoader) {
        try (InputStream is = classLoader.getResourceAsStream(MANIFEST_PATH);){
            this.startClass = this.analysis(is);
        }
        catch (IOException e) {
            throw new ServerBootstrapException("");
        }
    }

    private String analysis(InputStream is) throws IOException {
        Attributes attributes = new Manifest(is).getMainAttributes();
        return attributes.getValue(START_CLASS_KEY);
    }

    public String getStartClass() {
        return this.startClass;
    }
}

