/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.game.monitor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import xyz.noark.core.thread.MonitorThreadPool;
import xyz.noark.core.thread.NamedThreadFactory;
import xyz.noark.game.monitor.AbstractMonitorService;
import xyz.noark.log.LogHelper;

public class MonitorManager
implements MonitorThreadPool {
    private static final int POOL_SIZE = 1;
    private static final int SHUTDOWN_MAX_TIME = 5;
    private final ScheduledExecutorService scheduledExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("monitor", false));

    public ExecutorService getMonitorService() {
        return this.scheduledExecutor;
    }

    public void addMonitorService(AbstractMonitorService monitorService) {
        this.scheduledExecutor.scheduleWithFixedDelay(monitorService, monitorService.getInitialDelay(), monitorService.getDelay(), monitorService.getUnit());
    }

    public void shutdown() {
        LogHelper.logger.info("\u5f00\u59cb\u901a\u77e5\u76d1\u63a7\u670d\u52a1\u7ebf\u7a0b\u6c60\u505c\u6b62\u670d\u52a1.");
        this.scheduledExecutor.shutdown();
        try {
            if (!this.scheduledExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduledExecutor.shutdownNow();
            }
            LogHelper.logger.info("\u5904\u7406\u76d1\u63a7\u670d\u52a1\u7ebf\u7a0b\u6c60\u5df2\u505c\u6b62\u670d\u52a1");
        }
        catch (InterruptedException ie) {
            LogHelper.logger.error("\u505c\u6b62\u76d1\u63a7\u670d\u52a1\u7ebf\u7a0b\u65f6\u53d1\u751f\u5f02\u5e38.", new Object[]{ie});
            this.scheduledExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

