/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.game.monitor.impl;

import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import xyz.noark.core.util.FieldUtils;
import xyz.noark.core.util.FileUtils;
import xyz.noark.game.monitor.AbstractMonitorService;
import xyz.noark.log.LogHelper;

public class NettyDirectMemoryMonitorService
extends AbstractMonitorService {
    private final AtomicLong DIRECT_MEMORY_COUNTER;

    public NettyDirectMemoryMonitorService() {
        Field field = FieldUtils.getField(PlatformDependent.class, (String)"DIRECT_MEMORY_COUNTER");
        this.DIRECT_MEMORY_COUNTER = (AtomicLong)FieldUtils.readField(null, (Field)field);
    }

    @Override
    protected long getInitialDelay() {
        return 60L;
    }

    @Override
    protected long getDelay() {
        return 60L;
    }

    @Override
    protected TimeUnit getUnit() {
        return TimeUnit.SECONDS;
    }

    @Override
    protected void exe() throws Exception {
        long cur = this.DIRECT_MEMORY_COUNTER.get();
        long max = PlatformDependent.maxDirectMemory();
        LogHelper.logger.info("netty direct memory cur={}, max={}", new Object[]{FileUtils.readableFileSize((long)cur), FileUtils.readableFileSize((long)max)});
    }
}

