/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.game.template;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.lang.PairHashMap;
import xyz.noark.core.lang.PairMap;
import xyz.noark.core.lang.TripleHashMap;
import xyz.noark.core.lang.TripleMap;
import xyz.noark.game.template.TemplateLoader;

public abstract class AbstractTemplateLoader
implements TemplateLoader {
    protected final String templatePath;
    protected final String zone;

    public AbstractTemplateLoader(String templatePath) {
        this(templatePath, "");
    }

    public AbstractTemplateLoader(String templatePath, String zone) {
        this.templatePath = templatePath;
        this.zone = zone;
        if (zone == null) {
            throw new ServerBootstrapException("\u7248\u672c\u76ee\u5f55\u914d\u7f6e\u4e0d\u53ef\u4ee5\u4e3anull,\u5982\u679c\u6ca1\u6709\u7248\u672c\u89c4\u5212\u8bf7\u4f7f\u7528\"\"");
        }
    }

    @Override
    public <K, T> Map<K, T> loadAll(Class<T> klass, Function<? super T, ? extends K> keyMapper) {
        return this.loadAll(klass).stream().collect(Collectors.toMap(keyMapper, Function.identity()));
    }

    @Override
    public <L, R, T> PairMap<L, R, T> loadAll(Class<T> klass, Function<? super T, ? extends L> leftMapper, Function<? super T, ? extends R> rightMapper) {
        return new PairHashMap(this.loadAll(klass), leftMapper, rightMapper);
    }

    @Override
    public <L, M, R, T> TripleMap<L, M, R, T> loadAll(Class<T> klass, Function<? super T, ? extends L> leftMapper, Function<? super T, ? extends M> middleMapper, Function<? super T, ? extends R> rightMapper) {
        return new TripleHashMap(this.loadAll(klass), leftMapper, middleMapper, rightMapper);
    }
}

