/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.game.template;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.exception.TemplateNotFoundException;
import xyz.noark.core.lang.PairMap;
import xyz.noark.core.lang.TripleMap;
import xyz.noark.game.template.TemplateLoader;

public abstract class AbstractTemplateManager {
    @Autowired
    protected TemplateLoader templateLoader;

    public abstract String getModuleName();

    public abstract void loadData();

    public void checkValidity() {
    }

    protected <T, K extends Serializable> T getTemplateOrElseThrow(Class<T> klass, Map<K, T> templates, K key) {
        return Optional.ofNullable(templates.get(key)).orElseThrow(() -> new TemplateNotFoundException(klass, key));
    }

    protected <T, L extends Serializable, R extends Serializable> T getTemplateOrElseThrow(Class<T> klass, PairMap<L, R, T> templates, L left, R right) {
        return (T)Optional.ofNullable(templates.get(left, right)).orElseThrow(() -> new TemplateNotFoundException(klass, left, right));
    }

    protected <T, L extends Serializable, M extends Serializable, R extends Serializable> T getTemplateOrElseThrow(Class<T> klass, TripleMap<L, M, R, T> templates, L left, M middle, R right) {
        return (T)Optional.ofNullable(templates.get(left, middle, right)).orElseThrow(() -> new TemplateNotFoundException(klass, left, middle, right));
    }
}

