/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.game.template.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import xyz.noark.core.annotation.tpl.TplFile;
import xyz.noark.core.exception.TplConfigurationException;
import xyz.noark.core.lang.ResourceLoader;
import xyz.noark.core.util.StringUtils;

class NoarkJson
extends ResourceLoader {
    NoarkJson() {
    }

    <T> List<T> loadAll(String templatePath, String zone, Class<T> klass) {
        TplFile file = klass.getAnnotation(TplFile.class);
        if (file == null) {
            throw new TplConfigurationException("\u8fd9\u4e0d\u662fJSON\u683c\u5f0f\u7684\u914d\u7f6e\u6587\u4ef6\u7c7b:" + klass.getName());
        }
        try {
            return JSON.parseArray((String)this.readString(templatePath, zone, file.value()), klass);
        }
        catch (IOException e) {
            throw new TplConfigurationException("JSON\u683c\u5f0f\u7684\u914d\u7f6e\u6587\u4ef6\u7c7b:" + klass.getName(), (Exception)e);
        }
    }

    private String readString(String templatePath, String zone, String fileName) throws IOException {
        try (InputStream is = this.newInputStream(templatePath, zone, fileName);){
            String string = StringUtils.readString((InputStream)is);
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T load(String templatePath, String zone, Class<T> klass) {
        TplFile file = klass.getAnnotation(TplFile.class);
        if (file == null) {
            throw new TplConfigurationException("\u8fd9\u4e0d\u662fJSON\u683c\u5f0f\u7684\u914d\u7f6e\u6587\u4ef6\u7c7b:" + klass.getName());
        }
        try (InputStream is = this.newInputStream(templatePath, zone, file.value());){
            Object object = JSON.parseObject((InputStream)is, klass, (Feature[])new Feature[0]);
            return (T)object;
        }
        catch (IOException e) {
            throw new TplConfigurationException("JSON\u683c\u5f0f\u7684\u914d\u7f6e\u6587\u4ef6\u7c7b:" + klass.getName(), (Exception)e);
        }
    }
}

