/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network;

import java.util.UUID;
import xyz.noark.core.lang.ByteArray;
import xyz.noark.core.network.PacketEncrypt;
import xyz.noark.core.util.CharsetUtils;
import xyz.noark.core.util.StringUtils;

public class DefaultPacketEncrypt
implements PacketEncrypt {
    private final byte[] secretKey;
    private final byte[] publicKey;
    private final boolean encrypt;

    public DefaultPacketEncrypt(boolean encrypt, byte[] secretKey) {
        this.encrypt = encrypt;
        this.secretKey = secretKey;
        this.publicKey = StringUtils.utf8Bytes((CharSequence)(encrypt ? UUID.randomUUID().toString() : ""));
    }

    public boolean isEncrypt() {
        return this.encrypt;
    }

    public String getPublicKey() {
        return new String(this.publicKey, CharsetUtils.CHARSET_UTF_8);
    }

    public void decode(ByteArray data, int incode) {
        int publicKeyIndex = 0;
        int secretKeyIndex = 0;
        int len = data.length();
        for (int i = 0; i < len; ++i) {
            byte value = data.getByte(i);
            value = (byte)(value ^ this.secretKey[secretKeyIndex++ % this.secretKey.length]);
            value = (byte)(value ^ this.publicKey[publicKeyIndex++ % this.publicKey.length]);
            value = (byte)(value ^ incode << 2);
            data.setByte(i, value);
        }
    }
}

