/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import java.io.IOException;
import java.io.Serializable;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Service;
import xyz.noark.core.annotation.Value;
import xyz.noark.core.network.NetworkListener;
import xyz.noark.core.network.Session;
import xyz.noark.core.network.SessionManager;
import xyz.noark.log.LogHelper;

@Service
@ChannelHandler.Sharable
public class NettyServerHandler
extends ChannelInboundHandlerAdapter {
    @Value(value="network.heartbeat")
    protected int heartbeat = 0;
    @Autowired(required=false)
    private NetworkListener networkListener;

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        LogHelper.logger.info("\u53d1\u73b0\u5ba2\u6237\u7aef\u94fe\u63a5\uff0cchannel={}", new Object[]{ctx.channel()});
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LogHelper.logger.info("\u5ba2\u6237\u7aef\u65ad\u5f00\u94fe\u63a5\uff0cchannel={}", new Object[]{ctx.channel()});
        Session session = SessionManager.getSession((Serializable)ctx.channel().id());
        if (session != null) {
            try {
                if (this.networkListener != null) {
                    this.networkListener.channelInactive(session);
                }
            }
            finally {
                SessionManager.removeSession((Session)session);
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
        if (this.heartbeat > 0 && evt instanceof IdleStateEvent) {
            ctx.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!(cause instanceof IOException)) {
            LogHelper.logger.debug("Netty\u6355\u83b7\u5f02\u5e38\uff0ccause={}", new Object[]{cause});
        }
    }
}

