/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import xyz.noark.network.codec.AbstractPacketCodec;

public abstract class AbstractLengthDecoder
extends ByteToMessageDecoder {
    private static final int MAX_PACKET_LENGTH = 65535;
    private final AbstractPacketCodec packetCodec;

    public AbstractLengthDecoder(AbstractPacketCodec packetCodec) {
        this.packetCodec = packetCodec;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        in.markReaderIndex();
        int preIndex = in.readerIndex();
        int length = this.readLength(in);
        if (preIndex == in.readerIndex()) {
            return;
        }
        if (length <= 0 || length > 65535) {
            ctx.close();
            return;
        }
        if (in.readableBytes() < length) {
            in.resetReaderIndex();
            return;
        }
        out.add(this.packetCodec.decodePacket(in.readRetainedSlice(length)));
    }

    protected abstract int readLength(ByteBuf var1);
}

