/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.filter;

import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Value;
import xyz.noark.core.network.NetworkListener;
import xyz.noark.core.network.NetworkPacket;
import xyz.noark.core.network.Session;
import xyz.noark.log.LogHelper;
import xyz.noark.network.IncodeSession;
import xyz.noark.network.filter.PacketCheckFilter;

public abstract class AbstractPacketCheckFilter
implements PacketCheckFilter {
    @Value(value="network.incode")
    protected boolean incode = false;
    @Value(value="network.checksum")
    protected boolean checksum = false;
    @Autowired(required=false)
    protected NetworkListener networkListener;

    @Override
    public boolean checkIncode(IncodeSession session, NetworkPacket packet) {
        if (this.incode && !this.checkPacketIncode(session, packet)) {
            LogHelper.logger.warn(" ^0^ duplicate packet. playerId={}, opcode={}", new Object[]{session.getPlayerId(), packet.getOpcode()});
            if (this.networkListener != null) {
                return this.networkListener.handleDuplicatePacket((Session)session, packet);
            }
        }
        return true;
    }

    protected abstract boolean checkPacketIncode(IncodeSession var1, NetworkPacket var2);

    @Override
    public boolean checkChecksum(Session session, NetworkPacket packet) {
        if (this.checksum && !this.checkPacketChecksum(packet)) {
            LogHelper.logger.warn(" ^0^ checksum fail. playerId={}, opcode={}", new Object[]{session.getPlayerId(), packet.getOpcode()});
            if (this.networkListener != null) {
                return this.networkListener.handleChecksumFail(session, packet);
            }
        }
        return true;
    }

    protected abstract boolean checkPacketChecksum(NetworkPacket var1);
}

