/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.BindException;
import java.util.concurrent.TimeUnit;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Component;
import xyz.noark.core.annotation.Value;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.network.TcpServer;
import xyz.noark.log.LogHelper;
import xyz.noark.network.InitializeDecoder;
import xyz.noark.network.InitializeHandlerManager;
import xyz.noark.network.NettyServerHandler;
import xyz.noark.network.NetworkConstant;
import xyz.noark.network.log.NettyLoggerFactory;

@Component(name={"NettyServer"})
public class NettyServer
implements TcpServer {
    private final ServerBootstrap bootstrap = new ServerBootstrap();
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workGroup;
    @Value(value="network.port")
    protected int port = 9527;
    @Value(value="network.heartbeat")
    protected int heartbeat = 0;
    @Value(value="network.workthreads")
    protected int workthreads = 0;
    @Value(value="network.log.active")
    protected boolean logActive = false;
    @Value(value="network.low.water.mark")
    private int defaultLowWaterMark = 32768;
    @Value(value="network.high.water.mark")
    private int defaultHighWaterMark = 65536;
    @Autowired
    protected InitializeHandlerManager initializeHandlerManager;
    @Autowired
    protected NettyServerHandler nettyServerHandler;

    public NettyServer() {
        int nThreads;
        int n = nThreads = this.workthreads == 0 ? NetworkConstant.DEFAULT_EVENT_LOOP_THREADS : this.workthreads;
        if (Epoll.isAvailable()) {
            this.bossGroup = new EpollEventLoopGroup(1);
            this.workGroup = new EpollEventLoopGroup(nThreads);
            this.bootstrap.group(this.bossGroup, this.workGroup).channel(EpollServerSocketChannel.class);
        } else {
            this.bossGroup = new NioEventLoopGroup(1);
            this.workGroup = new NioEventLoopGroup(nThreads);
            this.bootstrap.group(this.bossGroup, this.workGroup).channel(NioServerSocketChannel.class);
        }
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)65535);
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrap.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.defaultLowWaterMark, this.defaultHighWaterMark));
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                NettyServer.this.buildChannelPipeline(ch.pipeline());
            }
        });
    }

    protected void buildChannelPipeline(ChannelPipeline pipeline) {
        if (this.heartbeat > 0) {
            pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler((long)this.heartbeat, 0L, 0L, TimeUnit.SECONDS));
        }
        if (this.logActive) {
            pipeline.addLast("logger", (ChannelHandler)new LoggingHandler(LogLevel.DEBUG));
        }
        pipeline.addLast(new ChannelHandler[]{this.nettyServerHandler});
        pipeline.addLast(new ChannelHandler[]{new InitializeDecoder(this.initializeHandlerManager)});
    }

    public void startup() {
        LogHelper.logger.info("game tcp server start on {}", new Object[]{this.port});
        if (this.logActive) {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)NettyLoggerFactory.INSTANCE);
        }
        try {
            this.bootstrap.bind(this.port).sync();
            LogHelper.logger.info("game tcp server start is success.");
        }
        catch (Exception e) {
            if (e instanceof BindException) {
                throw new ServerBootstrapException("\u76ee\u6807\u7aef\u53e3\u5df2\u88ab\u5360\u7528 port=" + this.port, e);
            }
            throw new ServerBootstrapException("\u672a\u77e5\u5f02\u5e38", e);
        }
    }

    public void shutdown() {
        Future boosFuture = this.bossGroup.shutdownGracefully();
        Future workFuture = this.workGroup.shutdownGracefully();
        try {
            if (boosFuture.await(1L, TimeUnit.MINUTES)) {
                LogHelper.logger.info("NettyBoss\u5173\u95ed\u6210\u529f.");
            }
            if (workFuture.await(1L, TimeUnit.MINUTES)) {
                LogHelper.logger.info("NettyWork\u5173\u95ed\u6210\u529f.");
            }
        }
        catch (InterruptedException ie) {
            LogHelper.logger.error("\u5173\u95ed\u7f51\u7edc\u65f6\u53d1\u751f\u5f02\u5e38.", new Object[]{ie});
        }
    }
}

