/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import xyz.noark.core.lang.ByteArray;
import xyz.noark.core.network.AbstractSession;
import xyz.noark.core.network.NetworkProtocol;
import xyz.noark.core.network.PacketCodecHolder;
import xyz.noark.core.network.PacketEncrypt;
import xyz.noark.core.network.Session;
import xyz.noark.core.network.SessionAttr;
import xyz.noark.core.network.SessionAttrKey;
import xyz.noark.core.util.IpUtils;
import xyz.noark.log.LogHelper;
import xyz.noark.network.DefaultPacketEncrypt;
import xyz.noark.network.IncodeSession;

public class SocketSession
extends AbstractSession
implements IncodeSession {
    protected final Channel channel;
    protected final Map<SessionAttrKey<?>, SessionAttr<?>> attrs;
    private String uid;
    private Serializable playerId;
    protected PacketEncrypt packetEncrypt;
    protected int incode = -1;

    public SocketSession(Channel channel, boolean encrypt, byte[] secretKey) {
        super((Serializable)channel.id(), IpUtils.getIp((Channel)channel));
        this.channel = channel;
        this.attrs = new ConcurrentHashMap();
        this.packetEncrypt = new DefaultPacketEncrypt(encrypt, secretKey);
    }

    @Override
    public int getIncode() {
        return this.incode;
    }

    @Override
    public void setIncode(int incode) {
        this.incode = incode;
    }

    public void close() {
        this.channel.close();
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Serializable getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(Serializable playerId) {
        this.playerId = playerId;
    }

    public void send(Integer opcode, Object protocol) {
        this.send(this.buildPacket(opcode, protocol));
    }

    public void send(ByteArray packet) {
        if (!this.channel.isActive()) {
            LogHelper.logger.warn("send packet fail isActive=false. channel={}, playerId={}", new Object[]{this.channel, this.playerId});
            return;
        }
        if (!this.channel.isWritable()) {
            LogHelper.logger.warn("send packet fail isWritable=false. channel={}, playerId={}", new Object[]{this.channel, this.playerId});
            return;
        }
        this.writeAndFlush(packet);
    }

    public void send(NetworkProtocol networkProtocol) {
        this.send(PacketCodecHolder.getPacketCodec().encodePacket(networkProtocol));
    }

    protected void writeAndFlush(ByteArray packet) {
        this.channel.writeAndFlush((Object)packet, this.channel.voidPromise());
    }

    public void sendAndClose(Integer opcode, Object protocol) {
        this.channel.writeAndFlush((Object)this.buildPacket(opcode, protocol)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    protected ByteArray buildPacket(Integer opcode, Object protocol) {
        return PacketCodecHolder.getPacketCodec().encodePacket(new NetworkProtocol(opcode, protocol));
    }

    public void setPacketEncrypt(PacketEncrypt packetEncrypt) {
        this.packetEncrypt = packetEncrypt;
    }

    public PacketEncrypt getPacketEncrypt() {
        return this.packetEncrypt;
    }

    public <T> SessionAttr<T> attr(SessionAttrKey<T> key) {
        return this.attrs.computeIfAbsent(key, k -> new SessionAttr());
    }

    public void clearUidAndPlayerId() {
        this.uid = null;
        this.playerId = null;
        this.state = Session.State.CONNECTED;
    }
}

