/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.codec;

import io.netty.buffer.ByteBuf;
import xyz.noark.core.lang.ByteArray;

public class ByteBufWrapper
implements ByteArray {
    private final ByteBuf byteBuf;
    private byte[] array = null;

    public ByteBufWrapper(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    public byte[] array() {
        if (this.array == null) {
            this.array = new byte[this.byteBuf.readableBytes()];
            this.byteBuf.readBytes(this.array);
        }
        return this.array;
    }

    public void close() {
        this.byteBuf.release();
    }

    public int length() {
        return this.array == null ? this.byteBuf.readableBytes() : this.array.length;
    }

    public byte getByte(int index) {
        return this.array == null ? this.byteBuf.getByte(index) : this.array[index];
    }

    public void setByte(int index, byte value) {
        if (this.array == null) {
            this.byteBuf.setByte(index, (int)value);
        } else {
            this.array[index] = value;
        }
    }
}

