/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.codec.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.ByteToMessageDecoder;
import xyz.noark.core.lang.ByteArray;
import xyz.noark.core.lang.ByteArrayOutputStream;
import xyz.noark.core.lang.ImmutableByteArray;
import xyz.noark.core.network.NetworkPacket;
import xyz.noark.core.network.NetworkProtocol;
import xyz.noark.network.codec.AbstractPacketCodec;
import xyz.noark.network.codec.ByteBufWrapper;
import xyz.noark.network.codec.DefaultNetworkPacket;
import xyz.noark.network.codec.json.SimpleJsonLengthDecoder;
import xyz.noark.network.codec.json.SimpleJsonLengthEncoder;

public class SimpleJsonCodec
extends AbstractPacketCodec {
    public <T> T decodeProtocol(ByteArray bytes, Class<T> klass) {
        return (T)JSON.parseObject((byte[])bytes.array(), klass, (Feature[])new Feature[0]);
    }

    public ByteArray encodePacket(NetworkProtocol networkProtocol) {
        byte[] bytes = JSON.toJSONBytes((Object)networkProtocol.getProtocol(), (SerializerFeature[])new SerializerFeature[0]);
        ImmutableByteArray byteArray = new ImmutableByteArray(bytes.length + 4);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((ByteArray)byteArray);){
            byteArrayOutputStream.writeInt(networkProtocol.getOpcode().intValue());
            byteArrayOutputStream.writeBytes(bytes);
        }
        return byteArray;
    }

    public SimpleJsonLengthEncoder lengthEncoder() {
        return new SimpleJsonLengthEncoder();
    }

    @Override
    public ByteToMessageDecoder lengthDecoder() {
        return new SimpleJsonLengthDecoder(this);
    }

    @Override
    public NetworkPacket decodePacket(ByteBuf byteBuf) {
        DefaultNetworkPacket packet = new DefaultNetworkPacket();
        packet.setLength(byteBuf.readableBytes());
        packet.setOpcode(byteBuf.readInt());
        packet.setBytes(new ByteBufWrapper(byteBuf));
        return packet;
    }
}

