/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.codec.protobuf;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import xyz.noark.core.util.UnsignedUtils;
import xyz.noark.network.codec.AbstractLengthDecoder;
import xyz.noark.network.codec.AbstractPacketCodec;

public class ProtobufLengthDecoder
extends AbstractLengthDecoder {
    private static final int PACKET_BYTE_LENGTH = 2;

    public ProtobufLengthDecoder(AbstractPacketCodec packetCodec) {
        super(packetCodec);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 2) {
            return;
        }
        super.decode(ctx, in, out);
    }

    @Override
    protected int readLength(ByteBuf in) {
        return UnsignedUtils.toUnsigned((short)in.readShortLE());
    }
}

