/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.lang.reflect.Parameter;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import xyz.noark.core.converter.ConvertManager;
import xyz.noark.core.converter.Converter;
import xyz.noark.core.exception.ConvertException;
import xyz.noark.core.exception.UnrealizedException;
import xyz.noark.core.ioc.manager.HttpMethodManager;
import xyz.noark.core.ioc.wrap.method.HttpMethodWrapper;
import xyz.noark.core.ioc.wrap.param.HttpParamWrapper;
import xyz.noark.core.util.IpUtils;
import xyz.noark.core.util.Md5Utils;
import xyz.noark.log.LogHelper;
import xyz.noark.network.http.HttpResult;

public class HttpServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final String SIGN = "sign";
    private static final String TIME = "time";
    private final String secretKey;

    public HttpServerHandler(String secretKey) {
        this.secretKey = secretKey;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            if (msg instanceof FullHttpRequest) {
                this.handleFullHttpRequest(ctx, (FullHttpRequest)msg);
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    private void handleFullHttpRequest(ChannelHandlerContext ctx, FullHttpRequest request) {
        HttpResult result = this.exec(ctx, request);
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])JSON.toJSONString((Object)result).getBytes(DEFAULT_CHARSET));
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buf);
        ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResult exec(ChannelHandlerContext ctx, FullHttpRequest fhr) {
        HttpResult endExecuteTime2;
        Object returnValue;
        long startExecuteTime;
        HttpMethodWrapper handler;
        long createTime;
        String ip;
        block13: {
            ip = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress().getHostAddress();
            if (!IpUtils.isInnerIp((String)ip)) {
                LogHelper.logger.warn("client request's not authorized. ip={}, uri={}", new Object[]{ip, fhr.uri()});
                return new HttpResult(-2, "client request's not authorized.");
            }
            createTime = System.nanoTime();
            handler = HttpMethodManager.getInstance().getHttpHandler(fhr.uri());
            if (handler == null) {
                LogHelper.logger.warn("client request's API Unrealized. ip={}, uri={}", new Object[]{ip, fhr.uri()});
                return new HttpResult(-4, "client request's API Unrealized.");
            }
            if (handler.isDeprecated()) {
                LogHelper.logger.warn("client request's API Deprecated. ip={}, uri={}", new Object[]{ip, fhr.uri()});
                return new HttpResult(-6, "client request's API Deprecated.");
            }
            Map parameters = Collections.emptyMap();
            try {
                ByteBuf buf = fhr.content();
                byte[] bs = new byte[buf.readableBytes()];
                buf.readBytes(bs);
                parameters = (Map)JSON.parseObject((String)new String(bs, DEFAULT_CHARSET), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                LogHelper.logger.warn("client request's parameters not json. ip={}, uri={}, e={}", new Object[]{ip, fhr.uri(), e});
                return new HttpResult(-1, "client request's parameters not json.");
            }
            if (this.secretKey != null && !this.checkSign(parameters.getOrDefault(TIME, ""), (String)parameters.get(SIGN))) {
                LogHelper.logger.warn("client request's sign failed. ip={}, uri={}", new Object[]{ip, fhr.uri()});
                return new HttpResult(-3, "client request's sign failed.");
            }
            Object[] args = null;
            try {
                args = this.analysisParam(handler, fhr.uri(), parameters);
            }
            catch (Exception e) {
                LogHelper.logger.warn("client request's parameters are invalid, ip={}, uri={}, e={}", new Object[]{ip, fhr.uri(), e});
                return new HttpResult(-1, "client request's parameters are invalid, " + e.getMessage());
            }
            startExecuteTime = System.nanoTime();
            returnValue = null;
            returnValue = args == null ? handler.invoke(new Object[0]) : handler.invoke(args);
            if (!(returnValue instanceof HttpResult)) break block13;
            HttpResult httpResult = (HttpResult)returnValue;
            long endExecuteTime2 = System.nanoTime();
            LogHelper.logger.info("handle {},delay={} ms,exe={} ms,ip={}", new Object[]{handler.logCode(), Float.valueOf((float)(startExecuteTime - createTime) / 1000000.0f), Float.valueOf((float)(endExecuteTime2 - startExecuteTime) / 1000000.0f), ip});
            return httpResult;
        }
        try {
            HttpResult result = new HttpResult(0);
            result.setData(returnValue);
            endExecuteTime2 = result;
        }
        catch (Exception e) {
            HttpResult httpResult;
            try {
                LogHelper.logger.warn("server internal error, ip={}, uri={}, e={}", new Object[]{ip, fhr.uri(), e});
                httpResult = new HttpResult(-5, "server internal error, " + e.getMessage());
            }
            catch (Throwable throwable) {
                long endExecuteTime3 = System.nanoTime();
                LogHelper.logger.info("handle {},delay={} ms,exe={} ms,ip={}", new Object[]{handler.logCode(), Float.valueOf((float)(startExecuteTime - createTime) / 1000000.0f), Float.valueOf((float)(endExecuteTime3 - startExecuteTime) / 1000000.0f), ip});
                throw throwable;
            }
            long endExecuteTime4 = System.nanoTime();
            LogHelper.logger.info("handle {},delay={} ms,exe={} ms,ip={}", new Object[]{handler.logCode(), Float.valueOf((float)(startExecuteTime - createTime) / 1000000.0f), Float.valueOf((float)(endExecuteTime4 - startExecuteTime) / 1000000.0f), ip});
            return httpResult;
        }
        long endExecuteTime5 = System.nanoTime();
        LogHelper.logger.info("handle {},delay={} ms,exe={} ms,ip={}", new Object[]{handler.logCode(), Float.valueOf((float)(startExecuteTime - createTime) / 1000000.0f), Float.valueOf((float)(endExecuteTime5 - startExecuteTime) / 1000000.0f), ip});
        return endExecuteTime2;
    }

    public Object[] analysisParam(HttpMethodWrapper handler, String uri, Map<String, String> parameters) throws IOException {
        if (handler.getParameters().isEmpty()) {
            return null;
        }
        ArrayList<Object> args = new ArrayList<Object>(handler.getParameters().size());
        for (HttpParamWrapper param : handler.getParameters()) {
            Converter<?> converter = this.getConverter(param.getParameter());
            String data = parameters.get(param.getName());
            if (data == null) {
                if (param.getRequestParam().required()) {
                    throw new ConvertException("HTTP request param error. uri=" + uri + "," + param.getName() + " is required.");
                }
                try {
                    args.add(converter.convert(param.getParameter(), param.getRequestParam().defaultValue()));
                    continue;
                }
                catch (Exception e) {
                    throw new ConvertException("HTTP request default param error. uri=" + uri + "," + param.getName() + "=" + param.getRequestParam().defaultValue() + "-->" + converter.buildErrorMsg(), e);
                }
            }
            try {
                args.add(converter.convert(param.getParameter(), data));
            }
            catch (Exception e) {
                throw new ConvertException("HTTP request param error. uri=" + uri + "," + param.getName() + "=" + data + "-->" + converter.buildErrorMsg(), e);
            }
        }
        return args.toArray();
    }

    private Converter<?> getConverter(Parameter field) {
        Converter result = ConvertManager.getInstance().getConverter(field.getType());
        if (result == null) {
            throw new UnrealizedException("\u672a\u5b9e\u73b0\u7684\u6ce8\u5165(" + field.getType().getName() + ")" + field.getName());
        }
        return result;
    }

    private boolean checkSign(String time, String sign) {
        return Md5Utils.encrypt((String)new StringBuilder(time.length() + this.secretKey.length() + 1).append(this.secretKey).append("+").append(time).toString()).equalsIgnoreCase(sign);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LogHelper.logger.debug("HTTP\u5f02\u5e38. channel={}", new Object[]{ctx.channel(), cause});
        ctx.close();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        LogHelper.logger.debug("\u53d1\u73b0HTTP\u5ba2\u6237\u7aef\u94fe\u63a5\uff0cchannel={}", new Object[]{ctx.channel()});
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        LogHelper.logger.debug("HTTP\u5ba2\u6237\u7aef\u65ad\u5f00\u94fe\u63a5. channel={}", new Object[]{ctx.channel()});
    }
}

