/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.protobuf;

import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import xyz.noark.protobuf.ProtobufSerializable;
import xyz.noark.protobuf.decoder.ByteArrayDecoder;

public abstract class AbstractCodedOutputStream
implements AutoCloseable {
    private static final int FIXED_32_SIZE = 4;
    private static final int FIXED_64_SIZE = 8;
    private static final int MAX_VARINT_SIZE = 10;
    private static final Charset DEFAULT_STRING_CHARSET = Charset.forName("UTF-8");

    public static AbstractCodedOutputStream newInstance() {
        return new ByteArrayDecoder();
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public void writeBool(int tag, boolean value) {
        this.flushIfNotAvailable(11);
        this.bufferUInt32NoTag(tag);
        this.buffer((byte)(value ? 1 : 0));
    }

    public void writeInt32(int tag, int value) {
        this.flushIfNotAvailable(20);
        this.bufferUInt32NoTag(tag);
        this.bufferInt32NoTag(value);
    }

    public void writeSInt32(int tag, int value) {
        this.writeInt32(tag, AbstractCodedOutputStream.encodeZigZag32(value));
    }

    public void writeFixed32(int tag, int value) {
        this.flushIfNotAvailable(14);
        this.bufferUInt32NoTag(tag);
        this.bufferFixed32NoTag(value);
    }

    public void writeInt64(int tag, long value) {
        this.flushIfNotAvailable(20);
        this.bufferUInt32NoTag(tag);
        this.bufferUInt64NoTag(value);
    }

    public void writeSInt64(int tag, long value) {
        this.writeInt64(tag, AbstractCodedOutputStream.encodeZigZag64(value));
    }

    public void writeFixed64(int tag, long value) {
        this.flushIfNotAvailable(18);
        this.bufferUInt32NoTag(tag);
        this.bufferFixed64NoTag(value);
    }

    public void writeString(int tag, String value) {
        byte[] bytes = value.getBytes(DEFAULT_STRING_CHARSET);
        this.flushIfNotAvailable(20 + bytes.length);
        this.bufferUInt32NoTag(tag);
        this.bufferByteArrayNoTag(bytes);
    }

    public void writeFloat(int tag, float value) {
        this.writeFixed32(tag, Float.floatToRawIntBits(value));
    }

    public void writeDouble(int tag, double value) {
        this.writeFixed64(tag, Double.doubleToRawLongBits(value));
    }

    public <T extends ProtobufSerializable> void writeMessage(int tag, T value) {
        this.flushIfNotAvailable(10);
        this.bufferUInt32NoTag(tag);
        this.bufferMakeLengthIndex();
        value.writeTo(this);
        this.bufferWriteLength();
    }

    public void writeBoolList(int tag, List<Boolean> values, boolean packet) {
        if (packet) {
            this.flushIfNotAvailable(20 + values.size());
            this.bufferUInt32NoTag(tag);
            this.bufferUInt32NoTag(values.size());
            for (boolean value : values) {
                this.buffer((byte)(value ? 1 : 0));
            }
        } else {
            this.flushIfNotAvailable(11 * values.size());
            for (boolean value : values) {
                this.bufferUInt32NoTag(tag);
                this.buffer((byte)(value ? 1 : 0));
            }
        }
    }

    public void writeInt32List(int tag, List<Integer> values, boolean packet) {
        if (packet) {
            this.flushIfNotAvailable(10 * (2 + values.size()));
            this.bufferUInt32NoTag(tag);
            this.bufferUInt32NoTag(this.computeInt32Size(values));
            for (Integer value : values) {
                this.bufferInt32NoTag(value);
            }
        } else {
            this.flushIfNotAvailable(20 * values.size());
            for (Integer value : values) {
                this.bufferUInt32NoTag(tag);
                this.bufferInt32NoTag(value);
            }
        }
    }

    public void writeSInt32List(int tag, List<Integer> values, boolean packet) {
        if (packet) {
            this.flushIfNotAvailable(10 * (2 + values.size()));
            this.bufferUInt32NoTag(tag);
            this.bufferUInt32NoTag(this.computeSInt32Size(values));
            for (Integer value : values) {
                this.bufferInt32NoTag(AbstractCodedOutputStream.encodeZigZag32(value));
            }
        } else {
            this.flushIfNotAvailable(10 * (2 * values.size()));
            for (Integer value : values) {
                this.bufferUInt32NoTag(tag);
                this.bufferInt32NoTag(AbstractCodedOutputStream.encodeZigZag32(value));
            }
        }
    }

    public void writeFixed32List(int tag, List<Integer> values, boolean packet) {
        if (packet) {
            this.flushIfNotAvailable(20 + 4 * values.size());
            this.bufferUInt32NoTag(tag);
            this.bufferUInt32NoTag(4 * values.size());
            for (Integer value : values) {
                this.bufferFixed32NoTag(value);
            }
        } else {
            this.flushIfNotAvailable(14 * values.size());
            for (Integer value : values) {
                this.bufferUInt32NoTag(tag);
                this.bufferFixed32NoTag(value);
            }
        }
    }

    public void writeInt64List(int tag, List<Long> values, boolean packet) {
        if (packet) {
            this.flushIfNotAvailable(10 * (2 + values.size()));
            this.bufferUInt32NoTag(tag);
            this.bufferUInt32NoTag(this.computeInt64Size(values));
            for (Long value : values) {
                this.bufferUInt64NoTag(value);
            }
        } else {
            this.flushIfNotAvailable(10 * (2 * values.size()));
            for (Long value : values) {
                this.bufferUInt32NoTag(tag);
                this.bufferUInt64NoTag(value);
            }
        }
    }

    public void writeSInt64List(int tag, List<Long> values, boolean packet) {
        if (packet) {
            this.flushIfNotAvailable(10 * (2 + values.size()));
            this.bufferUInt32NoTag(tag);
            this.bufferUInt32NoTag(this.computeSInt64Size(values));
            for (Long value : values) {
                this.bufferUInt64NoTag(AbstractCodedOutputStream.encodeZigZag64(value));
            }
        } else {
            this.flushIfNotAvailable(10 * (2 * values.size()));
            for (Long value : values) {
                this.bufferUInt32NoTag(tag);
                this.bufferUInt64NoTag(AbstractCodedOutputStream.encodeZigZag64(value));
            }
        }
    }

    public void writeFixed64List(int tag, List<Long> values, boolean packet) {
        if (packet) {
            this.flushIfNotAvailable(20 + 8 * values.size());
            this.bufferUInt32NoTag(tag);
            this.bufferUInt32NoTag(8 * values.size());
            for (Long value : values) {
                this.bufferFixed64NoTag(value);
            }
        } else {
            this.flushIfNotAvailable(18 * values.size());
            for (Long value : values) {
                this.bufferUInt32NoTag(tag);
                this.bufferFixed64NoTag(value);
            }
        }
    }

    public void writeStringList(int tag, List<String> values, boolean packet) {
        if (packet) {
            int lenght = 0;
            LinkedList<byte[]> vs = new LinkedList<byte[]>();
            for (String string : values) {
                byte[] bytes = string.getBytes(DEFAULT_STRING_CHARSET);
                lenght += bytes.length;
                vs.add(bytes);
            }
            this.flushIfNotAvailable(20);
            this.bufferUInt32NoTag(tag);
            this.bufferUInt32NoTag(lenght);
            for (byte[] byArray : vs) {
                this.flushIfNotAvailable(10 + byArray.length);
                this.bufferByteArrayNoTag(byArray);
            }
        } else {
            for (String value : values) {
                this.writeString(tag, value);
            }
        }
    }

    public void writeMessageList(int tag, List<? extends ProtobufSerializable> values, boolean packet) {
        if (packet) {
            this.flushIfNotAvailable(20);
            this.bufferUInt32NoTag(tag);
            this.bufferMakeLengthIndex();
            for (ProtobufSerializable protobufSerializable : values) {
                protobufSerializable.writeTo(this);
            }
            this.bufferWriteLength();
        } else {
            for (ProtobufSerializable protobufSerializable : values) {
                this.writeMessage(tag, protobufSerializable);
            }
        }
    }

    private int computeInt32Size(List<Integer> values) {
        int sum = 0;
        for (Integer value : values) {
            sum += AbstractCodedOutputStream.computeInt32SizeNoTag(value);
        }
        return sum;
    }

    private int computeSInt32Size(List<Integer> values) {
        int sum = 0;
        for (Integer value : values) {
            sum += AbstractCodedOutputStream.computeInt32SizeNoTag(AbstractCodedOutputStream.encodeZigZag32(value));
        }
        return sum;
    }

    protected static int computeInt32SizeNoTag(int value) {
        if (value >= 0) {
            return AbstractCodedOutputStream.computeUInt32SizeNoTag(value);
        }
        return 10;
    }

    private static int computeUInt32SizeNoTag(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    private int computeInt64Size(List<Long> values) {
        int sum = 0;
        for (Long value : values) {
            sum += AbstractCodedOutputStream.computeInt64SizeNoTag(value);
        }
        return sum;
    }

    private int computeSInt64Size(List<Long> values) {
        int sum = 0;
        for (Long value : values) {
            sum += AbstractCodedOutputStream.computeInt64SizeNoTag(AbstractCodedOutputStream.encodeZigZag64(value));
        }
        return sum;
    }

    private static int computeInt64SizeNoTag(long value) {
        return AbstractCodedOutputStream.computeUInt64SizeNoTag(value);
    }

    private static int computeUInt64SizeNoTag(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (value < 0L) {
            return 10;
        }
        int n = 2;
        if ((value & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            value >>>= 28;
        }
        if ((value & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            value >>>= 14;
        }
        if ((value & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public abstract byte[] getByteArray();

    protected abstract void bufferMakeLengthIndex();

    protected abstract void bufferWriteLength();

    protected abstract void flushIfNotAvailable(int var1);

    protected abstract void buffer(byte var1);

    protected abstract void bufferInt32NoTag(int var1);

    protected abstract void bufferUInt64NoTag(long var1);

    protected abstract void bufferUInt32NoTag(int var1);

    protected abstract void bufferByteArrayNoTag(byte[] var1);

    protected abstract void bufferFixed32NoTag(int var1);

    protected abstract void bufferFixed64NoTag(long var1);

    @Override
    public abstract void close();
}

