/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.protobuf;

import xyz.noark.protobuf.AbstractCodedOutputStream;
import xyz.noark.protobuf.CodedInputStream;
import xyz.noark.protobuf.Packet;
import xyz.noark.protobuf.ProtobufSerializable;

public abstract class AbstractPacket
implements Packet,
ProtobufSerializable,
AutoCloseable {
    private static final ThreadLocal<AbstractCodedOutputStream> OUTPUTS = new ThreadLocal();

    private AbstractCodedOutputStream getCodedOutputStream() {
        AbstractCodedOutputStream output = OUTPUTS.get();
        if (output == null) {
            output = AbstractCodedOutputStream.newInstance();
            OUTPUTS.set(output);
        }
        return output;
    }

    @Override
    public byte[] toByteArray() {
        try (AbstractCodedOutputStream output = this.getCodedOutputStream();){
            this.writeTo(output);
            byte[] byArray = output.getByteArray();
            return byArray;
        }
    }

    @Override
    public void parseFrom(byte[] byteArray) {
        this.readFrom(new CodedInputStream(byteArray));
    }

    @Override
    public void close() throws Exception {
        OUTPUTS.remove();
    }
}

