/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.protobuf;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import xyz.noark.protobuf.ProtobufSerializable;

public class CodedInputStream {
    private static final Charset DEFAULT_STRING_CHARSET = Charset.forName("UTF-8");
    private final byte[] byteArray;
    private int bufferSize;
    private int pos;
    private static final int TAG_TYPE_BITS = 3;
    private static final int TAG_TYPE_MASK = 7;
    private static final int FIXED_32_SIZE = 4;
    private static final int FIXED_64_SIZE = 8;
    private static final int MAX_VARINT_SIZE = 10;

    public CodedInputStream(byte[] byteArray) {
        this.byteArray = byteArray;
        this.bufferSize = byteArray.length;
    }

    public int readTag() {
        if (this.isAtEnd()) {
            return 0;
        }
        return this.readInt32();
    }

    private boolean isAtEnd() {
        return this.pos == this.bufferSize;
    }

    public boolean skipField(int tag) {
        switch (tag & 7) {
            case 0: {
                this.skipRawVarint();
                return true;
            }
            case 1: {
                this.skipRawBytes(8);
                return true;
            }
            case 2: {
                this.skipRawBytes(this.readInt32());
                return true;
            }
            case 5: {
                this.skipRawBytes(4);
                return true;
            }
        }
        return true;
    }

    private void skipRawVarint() {
        for (int i = 0; i < 10; ++i) {
            if (this.byteArray[this.pos++] < 0) continue;
            return;
        }
    }

    public void skipRawBytes(int length) {
        this.pos += length;
    }

    public boolean readBool() {
        return this.byteArray[this.pos++] != 0;
    }

    public int readInt32() {
        block4: {
            int x;
            int tempPos;
            block6: {
                byte[] buffer;
                block8: {
                    block7: {
                        block5: {
                            tempPos = this.pos;
                            if (this.bufferSize == tempPos) break block4;
                            buffer = this.byteArray;
                            if ((x = buffer[tempPos++]) >= 0) {
                                this.pos = tempPos;
                                return x;
                            }
                            if (this.bufferSize - tempPos < 9) break block4;
                            if ((x ^= buffer[tempPos++] << 7) >= 0) break block5;
                            x ^= 0xFFFFFF80;
                            break block6;
                        }
                        if ((x ^= buffer[tempPos++] << 14) < 0) break block7;
                        x ^= 0x3F80;
                        break block6;
                    }
                    if ((x ^= buffer[tempPos++] << 21) >= 0) break block8;
                    x ^= 0xFFE03F80;
                    break block6;
                }
                byte y = buffer[tempPos++];
                x ^= y << 28;
                x ^= 0xFE03F80;
                if (y < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0) break block4;
            }
            this.pos = tempPos;
            return x;
        }
        return (int)this.readRawVarint64SlowPath();
    }

    private long readRawVarint64SlowPath() {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.byteArray[this.pos++];
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        return result;
    }

    public int readSInt32() {
        return CodedInputStream.decodeZigZag32(this.readInt32());
    }

    public int readFixed32() {
        return this.byteArray[this.pos++] & 0xFF | (this.byteArray[this.pos++] & 0xFF) << 8 | (this.byteArray[this.pos++] & 0xFF) << 16 | (this.byteArray[this.pos++] & 0xFF) << 24;
    }

    public long readInt64() {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.byteArray[this.pos++];
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        return result;
    }

    public long readSInt64() {
        return CodedInputStream.decodeZigZag64(this.readInt64());
    }

    public long readFixed64() {
        return (long)this.byteArray[this.pos++] & 0xFFL | ((long)this.byteArray[this.pos++] & 0xFFL) << 8 | ((long)this.byteArray[this.pos++] & 0xFFL) << 16 | ((long)this.byteArray[this.pos++] & 0xFFL) << 24 | ((long)this.byteArray[this.pos++] & 0xFFL) << 32 | ((long)this.byteArray[this.pos++] & 0xFFL) << 40 | ((long)this.byteArray[this.pos++] & 0xFFL) << 48 | ((long)this.byteArray[this.pos++] & 0xFFL) << 56;
    }

    public String readString() {
        int size = this.readInt32();
        if (size == 0) {
            return "";
        }
        String result = new String(this.byteArray, this.pos, size, DEFAULT_STRING_CHARSET);
        this.pos += size;
        return result;
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readFixed64());
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readFixed32());
    }

    public <T extends ProtobufSerializable> T readMessage(T message) {
        int size = this.readInt32();
        int makeEnd = this.bufferSize;
        this.bufferSize = this.pos + size;
        message.readFrom(this);
        this.bufferSize = makeEnd;
        return message;
    }

    public Collection<? extends Boolean> readBoolList() {
        int limit = this.pos + this.readInt32();
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        while (limit >= this.pos) {
            result.add(this.readBool());
        }
        return result;
    }

    public Collection<? extends Integer> readInt32List() {
        int limit = this.pos + this.readInt32();
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (limit >= this.pos) {
            result.add(this.readInt32());
        }
        return result;
    }

    public Collection<? extends Integer> readSInt32List() {
        int limit = this.pos + this.readInt32();
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (limit >= this.pos) {
            result.add(this.readSInt32());
        }
        return result;
    }

    public Collection<? extends Integer> readFixed32List() {
        int limit = this.pos + this.readInt32();
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (limit >= this.pos) {
            result.add(this.readFixed32());
        }
        return result;
    }

    public Collection<? extends Long> readInt64List() {
        int limit = this.pos + this.readInt32();
        ArrayList<Long> result = new ArrayList<Long>();
        while (limit >= this.pos) {
            result.add(this.readInt64());
        }
        return result;
    }

    public Collection<? extends Long> readFixed64List() {
        int limit = this.pos + this.readInt32();
        ArrayList<Long> result = new ArrayList<Long>();
        while (limit >= this.pos) {
            result.add(this.readFixed64());
        }
        return result;
    }

    public Collection<? extends Long> readSInt64List() {
        int limit = this.pos + this.readInt32();
        ArrayList<Long> result = new ArrayList<Long>();
        while (limit >= this.pos) {
            result.add(this.readSInt64());
        }
        return result;
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }
}

