/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.protobuf.decoder;

import xyz.noark.protobuf.AbstractCodedOutputStream;

public class ByteArrayDecoder
extends AbstractCodedOutputStream {
    private byte[] buffer = new byte[this.limit];
    private int limit = 1024;
    private int position;
    private MakeNode makePosition;

    @Override
    protected void flushIfNotAvailable(int minCapacity) {
        if (this.limit - this.position <= minCapacity) {
            this.limit += Math.max(minCapacity, 512);
            byte[] bytes = new byte[this.limit];
            System.arraycopy(this.buffer, 0, bytes, 0, this.position);
            this.buffer = bytes;
        }
    }

    @Override
    protected void bufferMakeLengthIndex() {
        this.makePosition = new MakeNode(this.makePosition, this.position++);
    }

    @Override
    protected void bufferWriteLength() {
        int length = this.position - this.makePosition.getIndex() - 1;
        int size = ByteArrayDecoder.computeInt32SizeNoTag(length);
        if (size > 1) {
            System.arraycopy(this.buffer, this.makePosition.getIndex() + 1, this.buffer, this.makePosition.getIndex() + size, length);
        }
        int nowPosition = this.position + size - 1;
        this.position = this.makePosition.getIndex();
        this.bufferUInt32NoTag(length);
        this.position = nowPosition;
        this.makePosition = this.makePosition.getPreNode();
    }

    @Override
    protected void buffer(byte value) {
        this.buffer[this.position++] = value;
    }

    @Override
    protected void bufferInt32NoTag(int value) {
        if (value >= 0) {
            this.bufferUInt32NoTag(value);
        } else {
            this.bufferUInt64NoTag(value);
        }
    }

    @Override
    protected void bufferUInt32NoTag(int value) {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.buffer[this.position++] = (byte)value;
                return;
            }
            this.buffer[this.position++] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    @Override
    protected final void bufferUInt64NoTag(long value) {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.buffer[this.position++] = (byte)value;
                return;
            }
            this.buffer[this.position++] = (byte)((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    @Override
    protected final void bufferFixed32NoTag(int value) {
        this.buffer[this.position++] = (byte)(value & 0xFF);
        this.buffer[this.position++] = (byte)(value >> 8 & 0xFF);
        this.buffer[this.position++] = (byte)(value >> 16 & 0xFF);
        this.buffer[this.position++] = (byte)(value >> 24 & 0xFF);
    }

    @Override
    protected final void bufferFixed64NoTag(long value) {
        this.buffer[this.position++] = (byte)(value & 0xFFL);
        this.buffer[this.position++] = (byte)(value >> 8 & 0xFFL);
        this.buffer[this.position++] = (byte)(value >> 16 & 0xFFL);
        this.buffer[this.position++] = (byte)(value >> 24 & 0xFFL);
        this.buffer[this.position++] = (byte)((int)(value >> 32) & 0xFF);
        this.buffer[this.position++] = (byte)((int)(value >> 40) & 0xFF);
        this.buffer[this.position++] = (byte)((int)(value >> 48) & 0xFF);
        this.buffer[this.position++] = (byte)((int)(value >> 56) & 0xFF);
    }

    @Override
    protected void bufferByteArrayNoTag(byte[] bytes) {
        int length = bytes.length;
        this.bufferUInt32NoTag(length);
        System.arraycopy(bytes, 0, this.buffer, this.position, length);
        this.position += length;
    }

    @Override
    public void close() {
        this.position = 0;
    }

    @Override
    public byte[] getByteArray() {
        if (this.position == 0) {
            return new byte[0];
        }
        byte[] retBytes = new byte[this.position];
        System.arraycopy(this.buffer, 0, retBytes, 0, this.position);
        return retBytes;
    }

    private static class MakeNode {
        private int index;
        private MakeNode preNode;

        public MakeNode(MakeNode makePosition, int i) {
            this.preNode = makePosition;
            this.index = i;
        }

        public int getIndex() {
            return this.index;
        }

        public MakeNode getPreNode() {
            return this.preNode;
        }
    }
}

