/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.redis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.Tuple;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.log.LogHelper;

public class Redis {
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int DEFAULT_INDEX = 0;
    private static final String PONG = "PONG";
    private final JedisPool pool;

    public Redis(String host, int port) {
        this(host, port, 0);
    }

    public Redis(String host, int port, int database) {
        this(host, port, null, database);
    }

    public Redis(String host, int port, String password) {
        this(host, port, password, 0);
    }

    public Redis(String host, int port, String password, int index) {
        this.pool = new JedisPool(new GenericObjectPoolConfig(), host, port, 3000, password, index);
        LogHelper.logger.info("redis info. host={},port={},database={},password={}", new Object[]{host, port, index, password});
    }

    public Redis ping() {
        try (Jedis j = this.pool.getResource();){
            if (PONG.equals(j.ping())) {
                LogHelper.logger.info("Redis\u94fe\u63a5\u6b63\u5e38.");
            } else {
                LogHelper.logger.warn("Redis\u94fe\u63a5\u5f02\u5e38.");
            }
        }
        catch (Exception e) {
            throw new ServerBootstrapException("Redis ping exception.", e);
        }
        return this;
    }

    public long del(String ... keys) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.del(keys);
            return l;
        }
    }

    public byte[] dump(String key) {
        try (Jedis jedis = this.pool.getResource();){
            byte[] byArray = jedis.dump(key);
            return byArray;
        }
    }

    public String restore(String key, int ttl, byte[] serializedValue) {
        try (Jedis jedis = this.pool.getResource();){
            String string = jedis.restore(key, ttl, serializedValue);
            return string;
        }
    }

    public boolean exists(String key) {
        try (Jedis jedis = this.pool.getResource();){
            boolean bl = jedis.exists(key);
            return bl;
        }
    }

    public long expire(String key, int seconds) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.expire(key, seconds);
            return l;
        }
    }

    public long expireAt(String key, long unixTime) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.expireAt(key, unixTime);
            return l;
        }
    }

    public Set<String> keys(String pattern) {
        try (Jedis jedis = this.pool.getResource();){
            Set set = jedis.keys(pattern);
            return set;
        }
    }

    public long decr(String key) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.decr(key);
            return l;
        }
    }

    public long decrBy(String key, long decrement) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.decrBy(key, decrement);
            return l;
        }
    }

    public String get(String key) {
        try (Jedis jedis = this.pool.getResource();){
            String string = jedis.get(key);
            return string;
        }
    }

    public long incr(String key) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.incr(key);
            return l;
        }
    }

    public long incrBy(String key, long increment) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.incrBy(key, increment);
            return l;
        }
    }

    public List<String> mget(String ... keys) {
        try (Jedis jedis = this.pool.getResource();){
            List list = jedis.mget(keys);
            return list;
        }
    }

    public void mset(String ... keysvalues) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.mset(keysvalues);
        }
    }

    public long msetnx(String ... keysvalues) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.msetnx(keysvalues);
            return l;
        }
    }

    public String set(String key, String value) {
        try (Jedis jedis = this.pool.getResource();){
            String string = jedis.set(key, value);
            return string;
        }
    }

    public String set(String key, String value, String nxxx) {
        try (Jedis jedis = this.pool.getResource();){
            String string = jedis.set(key, value, nxxx);
            return string;
        }
    }

    public String set(String key, String value, String nxxx, String expx, int time) {
        try (Jedis jedis = this.pool.getResource();){
            String string = jedis.set(key, value, nxxx, expx, time);
            return string;
        }
    }

    public String set(String key, String value, String nxxx, String expx, long time) {
        try (Jedis jedis = this.pool.getResource();){
            String string = jedis.set(key, value, nxxx, expx, time);
            return string;
        }
    }

    public long hdel(String key, String ... field) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.hdel(key, field);
            return l;
        }
    }

    public boolean hexists(String key, String field) {
        try (Jedis jedis = this.pool.getResource();){
            boolean bl = jedis.hexists(key, field);
            return bl;
        }
    }

    public String hget(String key, String field) {
        try (Jedis jedis = this.pool.getResource();){
            String string = jedis.hget(key, field);
            return string;
        }
    }

    public Map<String, String> hgetAll(String key) {
        try (Jedis jedis = this.pool.getResource();){
            Map map = jedis.hgetAll(key);
            return map;
        }
    }

    public long hincrBy(String key, String field, long value) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.hincrBy(key, field, value);
            return l;
        }
    }

    public Set<String> hkeys(String key) {
        try (Jedis jedis = this.pool.getResource();){
            Set set = jedis.hkeys(key);
            return set;
        }
    }

    public long hlen(String key) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.hlen(key);
            return l;
        }
    }

    public List<String> hmget(String key, String ... fields) {
        try (Jedis jedis = this.pool.getResource();){
            List list = jedis.hmget(key, fields);
            return list;
        }
    }

    public void hmset(String key, Map<String, String> value) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.hmset(key, value);
        }
    }

    public Long hset(String key, String field, String value) {
        try (Jedis jedis = this.pool.getResource();){
            Long l = jedis.hset(key, field, value);
            return l;
        }
    }

    public long hsetnx(String key, String field, String value) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.hsetnx(key, field, value);
            return l;
        }
    }

    public List<String> hvals(String key) {
        try (Jedis jedis = this.pool.getResource();){
            List list = jedis.hvals(key);
            return list;
        }
    }

    public long zadd(String key, double score, String member) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.zadd(key, score, member);
            return l;
        }
    }

    public long zadd(String key, Map<String, Double> scoreMembers) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.zadd(key, scoreMembers);
            return l;
        }
    }

    public long zcard(String key) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.zcard(key);
            return l;
        }
    }

    public long zcount(String key, double min, double max) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.zcount(key, min, max);
            return l;
        }
    }

    public long zcount(String key, String min, String max) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.zcount(key, min, max);
            return l;
        }
    }

    public double zincrby(String key, double increment, String member) {
        try (Jedis jedis = this.pool.getResource();){
            double d = jedis.zincrby(key, increment, member);
            return d;
        }
    }

    public Set<String> zrange(String key, long start, long end) {
        try (Jedis jedis = this.pool.getResource();){
            Set set = jedis.zrange(key, start, end);
            return set;
        }
    }

    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        try (Jedis jedis = this.pool.getResource();){
            Set set = jedis.zrangeWithScores(key, start, end);
            return set;
        }
    }

    public Long zrank(String key, String member) {
        try (Jedis jedis = this.pool.getResource();){
            Long l = jedis.zrank(key, member);
            return l;
        }
    }

    public long zrem(String key, String ... members) {
        try (Jedis jedis = this.pool.getResource();){
            long l = jedis.zrem(key, members);
            return l;
        }
    }

    public Long zrevrank(String key, String member) {
        try (Jedis jedis = this.pool.getResource();){
            Long l = jedis.zrevrank(key, member);
            return l;
        }
    }

    public Double zscore(String key, String member) {
        try (Jedis jedis = this.pool.getResource();){
            Double d = jedis.zscore(key, member);
            return d;
        }
    }

    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.psubscribe(jedisPubSub, patterns);
        }
    }

    public void publish(String channel, String message) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.publish(channel, message);
        }
    }

    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.subscribe(jedisPubSub, channels);
        }
    }

    public Object eval(String script) {
        try (Jedis jedis = this.pool.getResource();){
            Object object = jedis.eval(script);
            return object;
        }
    }

    public void destory() {
        this.pool.destroy();
    }

    public Jedis getJedis() {
        return this.pool.getResource();
    }
}

