/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.robot;

import java.util.Date;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Controller;
import xyz.noark.core.annotation.Value;
import xyz.noark.core.annotation.controller.EventListener;
import xyz.noark.core.annotation.controller.ExecThreadGroup;
import xyz.noark.core.event.DelayEvent;
import xyz.noark.core.event.EventManager;
import xyz.noark.core.util.DateUtils;
import xyz.noark.robot.RobotAiEvent;
import xyz.noark.robot.RobotManager;

@Controller(threadGroup=ExecThreadGroup.PlayerThreadGroup)
public class RobotAiController {
    @Autowired
    private EventManager eventManager;
    @Autowired
    private RobotManager robotManager;
    @Value(value="robot.ai.interval")
    private int aiInterval = 1;

    @EventListener(printLog=false)
    public void handleRobotAiEvent(RobotAiEvent event) {
        try {
            this.robotManager.getRobot(event.getPlayerId()).tick();
        }
        finally {
            this.eventManager.publish((DelayEvent)new RobotAiEvent(event.getPlayerId(), DateUtils.addSeconds((Date)new Date(), (int)this.aiInterval)));
        }
    }
}

