/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.robot;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Service;
import xyz.noark.core.annotation.Value;
import xyz.noark.core.event.DelayEvent;
import xyz.noark.core.event.EventManager;
import xyz.noark.core.network.PacketCodecHolder;
import xyz.noark.core.network.Session;
import xyz.noark.core.network.SessionManager;
import xyz.noark.core.util.DateUtils;
import xyz.noark.core.util.ThreadUtils;
import xyz.noark.log.LogHelper;
import xyz.noark.network.codec.AbstractPacketCodec;
import xyz.noark.robot.AbstractRobotBootstrap;
import xyz.noark.robot.Robot;
import xyz.noark.robot.RobotAiEvent;
import xyz.noark.robot.RobotClientHandler;
import xyz.noark.robot.RobotSession;

@Service
public class RobotManager {
    private static final Bootstrap BOOTSTRAP = new Bootstrap();
    private final ConcurrentMap<String, Robot> robots = new ConcurrentHashMap<String, Robot>(2048);
    @Value(value="robot.num")
    private int robotNum = 1;
    @Value(value="robot.create.interval")
    private int createInterval = 1;
    @Value(value="robot.ai.interval")
    private int aiInterval = 1;
    @Value(value="robot.account.prefix")
    private String accountPrefix = "robot:";
    @Autowired
    private EventManager eventManager;
    @Autowired
    private RobotClientHandler robotClientHandler;

    @PostConstruct
    public void initBootstrap() {
        final AbstractPacketCodec packetCodec = (AbstractPacketCodec)PacketCodecHolder.getPacketCodec();
        BOOTSTRAP.group((EventLoopGroup)new NioEventLoopGroup());
        ((Bootstrap)BOOTSTRAP.channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)packetCodec.lengthDecoder());
                pipeline.addLast("encoder", packetCodec.lengthEncoder());
                pipeline.addLast("hanlder", (ChannelHandler)RobotManager.this.robotClientHandler);
            }
        });
    }

    public void init(AbstractRobotBootstrap bootstrap) {
        LogHelper.logger.info("\u73af\u5883\u51c6\u5907OK\uff0c\u5f00\u59cb\u521b\u5efa\u673a\u5668\u4eba...");
        for (int id = 1; id <= this.robotNum; ++id) {
            Robot robot = this.createRobot(id, bootstrap);
            this.robots.put(robot.getPlayerId(), robot);
            this.eventManager.publish((DelayEvent)new RobotAiEvent(robot.getPlayerId(), DateUtils.addSeconds((Date)new Date(), (int)this.aiInterval)));
            ThreadUtils.sleep((long)(1L * (long)this.createInterval * 1000L));
        }
    }

    private Robot createRobot(int id, AbstractRobotBootstrap bootstrap) {
        LogHelper.logger.info("\u521b\u5efa\u673a\u5668\u4eba id={}", new Object[]{id});
        String playerId = this.accountPrefix + id;
        return new Robot(playerId, bootstrap.rebuildAi(playerId));
    }

    public Robot getRobot(String playerId) {
        return (Robot)this.robots.get(playerId);
    }

    public <T> T getData(String playerId, Class<? extends T> klass) {
        return ((Robot)this.robots.get(playerId)).getData(klass);
    }

    public void connect(String playerId, String ip, int port) throws InterruptedException {
        LogHelper.logger.debug("TCP\u94fe\u63a5");
        Channel channel = BOOTSTRAP.connect(ip, port).sync().channel();
        LogHelper.logger.debug("\u94fe\u63a5\u6210\u529f\uff0c\u53d1\u9001\u6697\u53f7\uff0c\u8bf7\u6c42\u5bc6\u94a5...");
        RobotSession session = (RobotSession)SessionManager.createSession((Serializable)channel.id(), key -> new RobotSession(channel));
        session.setPlayerId(playerId);
        session.setState(Session.State.INGAME);
        SessionManager.bindPlayerIdAndSession((Serializable)session.getPlayerId(), (Session)session);
        LogHelper.logger.debug("\u521b\u5efaSession={}", new Object[]{session.getId()});
        channel.writeAndFlush((Object)"________socket_________");
    }
}

