/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.robot;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import xyz.noark.core.lang.ByteArray;
import xyz.noark.core.network.AbstractSession;
import xyz.noark.core.network.NetworkProtocol;
import xyz.noark.core.network.PacketCodecHolder;
import xyz.noark.core.network.PacketEncrypt;
import xyz.noark.core.network.Session;
import xyz.noark.core.network.SessionAttr;
import xyz.noark.core.network.SessionAttrKey;
import xyz.noark.log.LogHelper;

public class RobotSession
extends AbstractSession {
    protected final Channel channel;
    protected final Map<SessionAttrKey<?>, SessionAttr<?>> attrs;
    private String playerId;
    private PacketEncrypt packetEncrypt;

    public RobotSession(Channel channel) {
        super((Serializable)channel.id(), ((InetSocketAddress)channel.remoteAddress()).getAddress().getHostAddress());
        this.channel = channel;
        this.attrs = new ConcurrentHashMap();
    }

    public void close() {
        this.channel.close();
    }

    public String getUid() {
        return this.playerId;
    }

    public Serializable getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
    }

    public void send(Serializable opcode, Object protocol) {
        this.send(this.buildPacket(opcode, protocol));
    }

    public void send(ByteArray packet) {
        if (!this.channel.isActive()) {
            LogHelper.logger.debug("send packet fail isActive=false. channel={}, playerId={}", new Object[]{this.channel, this.getPlayerId()});
            return;
        }
        if (!this.channel.isWritable()) {
            LogHelper.logger.debug("send packet fail isWritable=false. channel={}, playerId={}", new Object[]{this.channel, this.getPlayerId()});
            return;
        }
        this.writeAndFlush(packet);
    }

    public void send(NetworkProtocol networkProtocol) {
        this.send(PacketCodecHolder.getPacketCodec().encodePacket(networkProtocol));
    }

    protected void writeAndFlush(ByteArray packet) {
        this.channel.writeAndFlush((Object)packet, this.channel.voidPromise());
    }

    public void sendAndClose(Serializable opcode, Object protocol) {
        this.channel.writeAndFlush((Object)this.buildPacket(opcode, protocol)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    protected ByteArray buildPacket(Serializable opcode, Object protocol) {
        return PacketCodecHolder.getPacketCodec().encodePacket(new NetworkProtocol(opcode, protocol));
    }

    public PacketEncrypt getPacketEncrypt() {
        return this.packetEncrypt;
    }

    public void setPacketEncrypt(PacketEncrypt packetEncrypt) {
        this.packetEncrypt = packetEncrypt;
    }

    public <T> SessionAttr<T> attr(SessionAttrKey<T> key) {
        return this.attrs.computeIfAbsent(key, k -> new SessionAttr());
    }

    public void clearUidAndPlayerId() {
        this.playerId = null;
        this.state = Session.State.CONNECTED;
    }
}

