/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.xml;

import java.lang.reflect.Field;
import org.xml.sax.helpers.DefaultHandler;
import xyz.noark.core.annotation.tpl.TplAttr;
import xyz.noark.core.converter.ConvertManager;
import xyz.noark.core.converter.Converter;
import xyz.noark.core.exception.ConvertException;
import xyz.noark.core.exception.TplAttrRequiredException;
import xyz.noark.core.exception.UnrealizedException;
import xyz.noark.core.util.ClassUtils;
import xyz.noark.core.util.FieldUtils;
import xyz.noark.core.util.StringUtils;
import xyz.noark.xml.ObjectData;

abstract class AbstractXmlHandler<T>
extends DefaultHandler {
    protected final Class<T> klass;
    protected final String tplFileName;

    protected AbstractXmlHandler(Class<T> klass, String tplFileName) {
        this.klass = klass;
        this.tplFileName = tplFileName;
    }

    protected T buildObject(ObjectData data, boolean fixEl) {
        if (fixEl) {
            data.fillExpression();
        }
        Object result = ClassUtils.newInstance(this.klass);
        for (Field field : this.klass.getDeclaredFields()) {
            TplAttr attr = field.getAnnotation(TplAttr.class);
            if (attr == null || StringUtils.isEmpty((String)attr.name())) continue;
            String value = data.getValue(attr.name());
            if (StringUtils.isEmpty((String)value)) {
                if (!attr.required()) continue;
                throw new TplAttrRequiredException(this.klass, field, attr);
            }
            Converter<?> converter = this.getConverter(field);
            try {
                FieldUtils.writeField((Object)result, (Field)field, (Object)converter.convert(field, value));
            }
            catch (Exception e) {
                throw new ConvertException(this.tplFileName + " >> " + field.getName() + " >> " + value + "-->" + converter.buildErrorMsg(), e);
            }
        }
        return (T)result;
    }

    private Converter<?> getConverter(Field field) {
        Converter result = ConvertManager.getInstance().getConverter(field.getType());
        if (result == null) {
            throw new UnrealizedException("XML\u914d\u7f6e\u89e3\u6790\u65f6\uff0c\u53d1\u73b0\u672a\u5b9e\u73b0\u7684\u7c7b\u578b. field=(" + field.getType().getName() + ")" + field.getName());
        }
        return result;
    }
}

