/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.xml;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import xyz.noark.core.annotation.tpl.TplFile;
import xyz.noark.core.exception.FileNotFoundException;
import xyz.noark.core.exception.TplConfigurationException;
import xyz.noark.xml.ArrayXmlHandler;
import xyz.noark.xml.ObjectXmlHandler;

public class Xml {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T load(Class<T> klass) {
        TplFile file = klass.getAnnotation(TplFile.class);
        if (file == null) {
            throw new TplConfigurationException("\u8fd9\u4e0d\u662fXML\u683c\u5f0f\u7684\u914d\u7f6e\u6587\u4ef6\u7c7b:" + klass.getName());
        }
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(file.value());){
            ObjectXmlHandler<T> handler = new ObjectXmlHandler<T>(klass, file.value());
            SAXParserFactory.newInstance().newSAXParser().parse(is, handler);
            T t = handler.getResult();
            return t;
        }
        catch (IOException e) {
            throw new FileNotFoundException("XML\u914d\u7f6e\u6587\u4ef6\u672a\u627e\u5230." + file.value(), (Exception)e);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new TplConfigurationException("\u683c\u5f0f\u5f02\u5e38:" + klass.getName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T load(Class<T> klass, Path path) {
        try (InputStream is = Files.newInputStream(path, StandardOpenOption.READ);){
            ObjectXmlHandler<T> handler = new ObjectXmlHandler<T>(klass, path.toString());
            SAXParserFactory.newInstance().newSAXParser().parse(is, handler);
            T t = handler.getResult();
            return t;
        }
        catch (IOException e) {
            throw new FileNotFoundException("XML\u914d\u7f6e\u6587\u4ef6\u672a\u627e\u5230." + path, (Exception)e);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new TplConfigurationException("\u683c\u5f0f\u5f02\u5e38:" + klass.getName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> List<T> loadAll(String templatePath, Class<T> klass) {
        TplFile file = klass.getAnnotation(TplFile.class);
        if (file == null) {
            throw new TplConfigurationException("\u8fd9\u4e0d\u662fXML\u683c\u5f0f\u7684\u914d\u7f6e\u6587\u4ef6\u7c7b:" + klass.getName());
        }
        try (InputStream is = Files.newInputStream(Paths.get(templatePath, file.value()), StandardOpenOption.READ);){
            ArrayXmlHandler<T> myhandler = new ArrayXmlHandler<T>(klass, file.value());
            SAXParserFactory.newInstance().newSAXParser().parse(is, myhandler);
            List<T> list = myhandler.getResult();
            return list;
        }
        catch (IOException e) {
            throw new FileNotFoundException("XML\u914d\u7f6e\u6587\u4ef6\u672a\u627e\u5230." + file.value(), (Exception)e);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new TplConfigurationException("\u683c\u5f0f\u5f02\u5e38:" + klass.getName(), e);
        }
    }
}

