/*
 * Decompiled with CFR 0.152.
 */
package xyz.proteanbear.template.excel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import xyz.proteanbear.template.annotation.PbPOIExcel;
import xyz.proteanbear.template.annotation.PbPOIExcelTitle;
import xyz.proteanbear.template.utils.ClassUtils;
import xyz.proteanbear.template.utils.FileSuffix;
import xyz.proteanbear.template.utils.Hex26Utils;
import xyz.proteanbear.template.utils.StringUtils;

public class PbPOIExcelTemplate {
    private int titleLine = 0;

    public List<?> readFrom(File excelFile, Class<?> returnClass) throws IOException, InvalidFormatException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ParseException {
        Workbook workbook = WorkbookFactory.create((File)excelFile);
        HashMap<String, Object> titleAnnotationMap = new HashMap<String, Object>();
        Map<String, Method> titleMethodMap = ClassUtils.titleMapSetMethodBy(PbPOIExcelTitle.class, returnClass, titleAnnotationMap);
        HashMap<String, String> indexTitleMap = new HashMap<String, String>();
        ArrayList result = new ArrayList();
        int pageNum = workbook.getNumberOfSheets();
        for (int page = 0; page < pageNum; ++page) {
            Sheet sheet = workbook.getSheetAt(page);
            Iterator rowItr = sheet.rowIterator();
            int rowNum = 0;
            while (rowItr.hasNext()) {
                Row row = (Row)rowItr.next();
                int colNum = row.getLastCellNum();
                if (this.titleLine == -1 && rowNum == 0) {
                    for (int i = 0; i < colNum; ++i) {
                        indexTitleMap.put(i + "", Hex26Utils.from(i + 1));
                    }
                } else if (this.titleLine == rowNum) {
                    for (int index = 0; index < colNum; ++index) {
                        indexTitleMap.put(index + "", this.valueOf(row.getCell(index)) + "");
                    }
                    ++rowNum;
                    continue;
                }
                Object object = returnClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (int index = 0; index < colNum; ++index) {
                    Method method = titleMethodMap.get(indexTitleMap.get(index + ""));
                    PbPOIExcelTitle annotation = (PbPOIExcelTitle)titleAnnotationMap.get(indexTitleMap.get(index + ""));
                    if (method == null) continue;
                    Object value = this.valueOf(row.getCell(index));
                    if (method.getParameterTypes()[0].isAssignableFrom(String.class)) {
                        Object object2 = value = value instanceof Date ? new SimpleDateFormat(annotation.dateFormat()).format(value) : value + "";
                    }
                    if (method.getParameterTypes()[0].isAssignableFrom(Date.class)) {
                        value = value instanceof String ? new SimpleDateFormat(annotation.dateFormat()).parse(value + "") : value;
                    }
                    method.invoke(object, value);
                }
                result.add(object);
                ++rowNum;
            }
        }
        return result;
    }

    public void writeTo(File excelFile, List<?> ... data) throws IOException {
        if (excelFile.exists()) {
            excelFile.delete();
        }
        excelFile.createNewFile();
        this.writeTo(FileSuffix.getBy(excelFile), new FileOutputStream(excelFile), data);
    }

    public void writeTo(FileSuffix fileSuffix, OutputStream outputStream, List<?> ... data) throws IOException {
        switch (fileSuffix) {
            case EXCEL_XLSX: {
                this.writeToXLSX(data).write(outputStream);
                break;
            }
            case EXCEL_XLS: {
                this.writeToXLS(data).write(outputStream);
                break;
            }
        }
    }

    public Object valueOf(Cell cell) {
        Object result = null;
        CellType type = cell.getCellTypeEnum();
        switch (type) {
            case STRING: {
                result = cell.getRichStringCellValue().toString().trim();
                break;
            }
            case NUMERIC: 
            case FORMULA: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    result = cell.getDateCellValue();
                    break;
                }
                result = cell.getNumericCellValue();
                break;
            }
            case BOOLEAN: {
                result = cell.getBooleanCellValue();
                break;
            }
        }
        return result;
    }

    public PbPOIExcelTemplate setTitleLine(int titleLine) {
        this.titleLine = titleLine;
        return this;
    }

    private XSSFWorkbook writeToXLSX(List<?> ... data) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        for (List<?> oneDataList : data) {
            Map<PbPOIExcelTitle, Method> getMethodMap;
            if (oneDataList.isEmpty()) continue;
            Class<?> curClass = oneDataList.get(0).getClass();
            PbPOIExcel pbPOIExcelAnnotation = oneDataList.get(0).getClass().getAnnotation(PbPOIExcel.class);
            if (pbPOIExcelAnnotation == null) continue;
            String sheetTitle = pbPOIExcelAnnotation.sheetTitle();
            XSSFSheet sheet = StringUtils.isBlank(sheetTitle) ? workbook.createSheet() : workbook.createSheet(sheetTitle);
            int curRow = 0;
            int index = 0;
            try {
                getMethodMap = ClassUtils.titleMapGetMethodBy(PbPOIExcelTitle.class, curClass);
                XSSFRow row = sheet.createRow(curRow++);
                for (PbPOIExcelTitle pbPOIExcelTitle : getMethodMap.keySet()) {
                    XSSFCell cell = row.createCell(index);
                    this.set((Cell)cell, pbPOIExcelTitle.value(), pbPOIExcelTitle);
                    ++index;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            for (Object anOneDataList : oneDataList) {
                XSSFRow row = sheet.createRow(curRow++);
                index = 0;
                for (PbPOIExcelTitle pbPOIExcelTitle : getMethodMap.keySet()) {
                    XSSFCell cell = row.createCell(index);
                    try {
                        this.set((Cell)cell, getMethodMap.get(pbPOIExcelTitle).invoke(anOneDataList, new Object[0]), pbPOIExcelTitle);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.set((Cell)cell, "", pbPOIExcelTitle);
                    }
                    ++index;
                }
            }
        }
        return workbook;
    }

    private HSSFWorkbook writeToXLS(List<?> ... data) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        for (List<?> oneDataList : data) {
            HSSFCell cell;
            HSSFRow row;
            Map<PbPOIExcelTitle, Method> getMethodMap;
            if (oneDataList.isEmpty()) continue;
            Class<?> curClass = oneDataList.get(0).getClass();
            PbPOIExcel pbPOIExcelAnnotation = oneDataList.get(0).getClass().getAnnotation(PbPOIExcel.class);
            if (pbPOIExcelAnnotation == null) continue;
            String sheetTitle = pbPOIExcelAnnotation.sheetTitle();
            HSSFSheet sheet = StringUtils.isBlank(sheetTitle) ? workbook.createSheet() : workbook.createSheet(sheetTitle);
            int curRow = 0;
            int index = 0;
            try {
                getMethodMap = ClassUtils.titleMapGetMethodBy(PbPOIExcelTitle.class, curClass);
                row = sheet.createRow(curRow++);
                for (PbPOIExcelTitle pbPOIExcelTitle : getMethodMap.keySet()) {
                    cell = row.createCell(index);
                    this.set((Cell)cell, pbPOIExcelTitle.value(), pbPOIExcelTitle);
                    ++index;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            for (PbPOIExcelTitle anOneDataList : oneDataList) {
                row = sheet.createRow(curRow++);
                index = 0;
                for (PbPOIExcelTitle pbPOIExcelTitle : getMethodMap.keySet()) {
                    cell = row.createCell(index);
                    try {
                        this.set((Cell)cell, getMethodMap.get(pbPOIExcelTitle).invoke((Object)anOneDataList, new Object[0]), pbPOIExcelTitle);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.set((Cell)cell, "", pbPOIExcelTitle);
                    }
                    ++index;
                }
            }
        }
        return workbook;
    }

    private void set(Cell cell, Object content, PbPOIExcelTitle pbPOIExcelTitle) {
        String textValue = null;
        if (content == null) {
            textValue = "";
        }
        if (content instanceof Boolean) {
            cell.setCellType(CellType.BOOLEAN);
            cell.setCellValue(((Boolean)content).booleanValue());
        } else if (content instanceof Date) {
            cell.setCellType(CellType.NUMERIC);
            cell.setCellValue((Date)content);
            Workbook workbook = cell.getSheet().getWorkbook();
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setDataFormat(workbook.createDataFormat().getFormat(pbPOIExcelTitle.dateFormat()));
            cell.setCellStyle(cellStyle);
        } else if (!(content instanceof byte[] || content instanceof File || content instanceof String && pbPOIExcelTitle.isFilePath())) {
            String string = textValue = content != null ? content.toString() : null;
        }
        if (textValue != null) {
            Pattern p = Pattern.compile("^//d+(//.//d+)?$");
            Matcher matcher = p.matcher(textValue);
            if (matcher.matches()) {
                cell.setCellType(CellType.NUMERIC);
                cell.setCellValue(Double.parseDouble(textValue));
            } else {
                cell.setCellType(CellType.STRING);
                XSSFRichTextString richString = new XSSFRichTextString(textValue);
                cell.setCellValue((RichTextString)richString);
            }
        }
    }
}

