/*
 * Decompiled with CFR 0.152.
 */
package xyz.proteanbear.template;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import xyz.proteanbear.template.annotation.PbPOIExcel;
import xyz.proteanbear.template.annotation.PbPOIExcelTitle;
import xyz.proteanbear.template.utils.ClassUtils;
import xyz.proteanbear.template.utils.FileSuffix;
import xyz.proteanbear.template.utils.Hex26Utils;
import xyz.proteanbear.template.utils.StringUtils;

public class PbPOIExcelTemplate {
    private int titleLine = 0;

    public List<?> readFrom(File excelFile, Class<?> returnClass) throws IOException, InvalidFormatException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ParseException {
        Workbook workbook = WorkbookFactory.create((File)excelFile);
        HashMap<String, Object> titleAnnotationMap = new HashMap<String, Object>();
        Map<String, Method> titleMethodMap = ClassUtils.titleMapSetMethodBy(PbPOIExcelTitle.class, returnClass, titleAnnotationMap);
        HashMap<String, String> indexTitleMap = new HashMap<String, String>();
        ArrayList result = new ArrayList();
        int pageNum = workbook.getNumberOfSheets();
        for (int page = 0; page < pageNum; ++page) {
            Sheet sheet = workbook.getSheetAt(page);
            Iterator rowItr = sheet.rowIterator();
            int rowNum = 0;
            while (rowItr.hasNext()) {
                Row row = (Row)rowItr.next();
                int colNum = row.getLastCellNum();
                if (this.titleLine == -1 && rowNum == 0) {
                    for (int i = 0; i < colNum; ++i) {
                        indexTitleMap.put(i + "", Hex26Utils.from(i + 1));
                    }
                } else if (this.titleLine == rowNum) {
                    for (int index = 0; index < colNum; ++index) {
                        indexTitleMap.put(index + "", this.valueOf(row.getCell(index)) + "");
                    }
                    ++rowNum;
                    continue;
                }
                Object object = returnClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (int index = 0; index < colNum; ++index) {
                    Object value;
                    Method method = titleMethodMap.get(indexTitleMap.get(index + ""));
                    PbPOIExcelTitle annotation = (PbPOIExcelTitle)titleAnnotationMap.get(indexTitleMap.get(index + ""));
                    if (method == null || (value = this.transform(this.valueOf(row.getCell(index)), method.getParameterTypes()[0], annotation)) == null) continue;
                    method.invoke(object, value);
                }
                result.add(object);
                ++rowNum;
            }
        }
        return result;
    }

    public void writeTo(File excelFile, List<?> ... data) throws IOException {
        if (excelFile.exists()) {
            excelFile.delete();
        }
        excelFile.createNewFile();
        this.writeTo(FileSuffix.getBy(excelFile), new FileOutputStream(excelFile), data);
    }

    public void writeTo(FileSuffix fileSuffix, OutputStream outputStream, List<?> ... data) throws IOException {
        Workbook workbook;
        switch (fileSuffix) {
            case EXCEL_XLSX: {
                workbook = WorkbookFactory.create((boolean)true);
                break;
            }
            default: {
                workbook = WorkbookFactory.create((boolean)false);
            }
        }
        for (List<?> oneDataList : data) {
            Map<PbPOIExcelTitle, Method> getMethodMap;
            if (oneDataList.isEmpty()) continue;
            Class<?> curClass = oneDataList.get(0).getClass();
            PbPOIExcel pbPOIExcelAnnotation = oneDataList.get(0).getClass().getAnnotation(PbPOIExcel.class);
            if (pbPOIExcelAnnotation == null) continue;
            String sheetTitle = pbPOIExcelAnnotation.sheetTitle();
            Sheet sheet = StringUtils.isBlank(sheetTitle) ? workbook.createSheet() : workbook.createSheet(sheetTitle);
            int curRow = 0;
            int index = 0;
            try {
                getMethodMap = ClassUtils.titleMapGetMethodBy(PbPOIExcelTitle.class, curClass);
                Row row = sheet.createRow(curRow++);
                for (PbPOIExcelTitle pbPOIExcelTitle : getMethodMap.keySet()) {
                    Cell cell = row.createCell(index);
                    this.set(cell, pbPOIExcelTitle.value(), pbPOIExcelTitle);
                    ++index;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            for (Object anOneDataList : oneDataList) {
                Row row = sheet.createRow(curRow++);
                index = 0;
                for (PbPOIExcelTitle pbPOIExcelTitle : getMethodMap.keySet()) {
                    Cell cell = row.createCell(index);
                    try {
                        this.set(cell, getMethodMap.get(pbPOIExcelTitle).invoke(anOneDataList, new Object[0]), pbPOIExcelTitle);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.set(cell, "", pbPOIExcelTitle);
                    }
                    ++index;
                }
            }
        }
        workbook.write(outputStream);
    }

    public Object valueOf(Cell cell) {
        Object result = null;
        if (cell == null) {
            return null;
        }
        CellType type = cell.getCellType();
        switch (type) {
            case STRING: {
                result = cell.getRichStringCellValue().toString().trim();
                break;
            }
            case NUMERIC: 
            case FORMULA: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    result = cell.getDateCellValue();
                    break;
                }
                result = cell.getNumericCellValue();
                break;
            }
            case BOOLEAN: {
                result = cell.getBooleanCellValue();
                break;
            }
        }
        return result;
    }

    private <T> T transform(Object value, Class<T> toClass, PbPOIExcelTitle annotation) throws ParseException {
        if (value == null) {
            return null;
        }
        if (toClass.isAssignableFrom(String.class)) {
            return (T)(value instanceof Date ? new SimpleDateFormat(annotation.dateFormat()).format(value) : String.valueOf(value));
        }
        if (toClass.isAssignableFrom(Date.class)) {
            return (T)(value instanceof String ? new SimpleDateFormat(annotation.dateFormat()).parse(String.valueOf(value)) : value);
        }
        if (!toClass.isAssignableFrom(String.class) && "".equals(value)) {
            return null;
        }
        return (T)value;
    }

    public PbPOIExcelTemplate setTitleLine(int titleLine) {
        this.titleLine = titleLine;
        return this;
    }

    private void set(Cell cell, Object content, PbPOIExcelTitle pbPOIExcelTitle) {
        String textValue = null;
        if (content == null) {
            textValue = "";
        }
        if (content instanceof Boolean) {
            cell.setCellValue(((Boolean)content).booleanValue());
        } else if (content instanceof Date) {
            cell.setCellValue((Date)content);
            Workbook workbook = cell.getSheet().getWorkbook();
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setDataFormat(workbook.createDataFormat().getFormat(pbPOIExcelTitle.dateFormat()));
            cell.setCellStyle(cellStyle);
        } else if (!(content instanceof byte[] || content instanceof File || content instanceof String && pbPOIExcelTitle.isFilePath())) {
            String string = textValue = content != null ? content.toString() : null;
        }
        if (textValue != null) {
            Pattern p = Pattern.compile("^//d+(//.//d+)?$");
            Matcher matcher = p.matcher(textValue);
            if (matcher.matches()) {
                cell.setCellValue(Double.parseDouble(textValue));
            } else {
                cell.setCellValue(textValue);
            }
        }
    }
}

