/*
 * Decompiled with CFR 0.152.
 */
package xyz.proteanbear.template;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.xwpf.usermodel.PositionInParagraph;
import org.apache.poi.xwpf.usermodel.TextSegment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import xyz.proteanbear.template.annotation.PbPOIWordVariable;
import xyz.proteanbear.template.utils.ClassUtils;
import xyz.proteanbear.template.utils.FileSuffix;

public class PbPOIWordTemplate {
    private String variableStart = "{";
    private String variableEnd = "}";
    private String loopStart = "[";
    private String loopEnd = "]";

    public PbPOIWordTemplate setVariableStart(String variableStart) {
        this.variableStart = variableStart;
        return this;
    }

    public PbPOIWordTemplate setVariableEnd(String variableEnd) {
        this.variableEnd = variableEnd;
        return this;
    }

    public PbPOIWordTemplate setLoopStart(String loopStart) {
        this.loopStart = loopStart;
        return this;
    }

    public PbPOIWordTemplate setLoopEnd(String loopEnd) {
        this.loopEnd = loopEnd;
        return this;
    }

    public void writeTo(File templateFile, File toFile, Object data) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (toFile.exists()) {
            toFile.delete();
        }
        toFile.createNewFile();
        this.writeTo(templateFile, FileSuffix.getBy(toFile), new FileOutputStream(toFile), data);
    }

    public void writeTo(File templateFile, FileSuffix fileSuffix, OutputStream outputStream, Object data) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (!templateFile.exists()) {
            throw new IOException("Template file is not exist");
        }
        XWPFDocument template = new XWPFDocument((InputStream)new FileInputStream(templateFile));
        Map<String, Object> dataMap = ClassUtils.dataMapBy(PbPOIWordVariable.class, data);
        List paragraphList = template.getParagraphs();
        paragraphList.forEach(paragraph -> this.replaceParagraph((XWPFParagraph)paragraph, dataMap));
        List tables = template.getTables();
        tables.forEach(table -> this.replaceTableParagraph((XWPFTable)table, dataMap));
        template.write(outputStream);
        outputStream.close();
        template.close();
    }

    private void replaceParagraph(XWPFParagraph paragraph, Map<String, Object> dataMap) {
        TextSegment start = paragraph.searchText(this.variableStart, new PositionInParagraph());
        if (start == null) {
            return;
        }
        TextSegment end = paragraph.searchText(this.variableEnd, new PositionInParagraph(start.getEndRun(), start.getEndText(), start.getEndChar()));
        if (end == null) {
            return;
        }
        String variableKey = paragraph.getText(new TextSegment(start.getBeginRun(), end.getEndRun(), start.getBeginText(), end.getEndText(), start.getBeginChar(), end.getEndChar()));
        Object variable = dataMap.getOrDefault(variableKey = variableKey.replace(this.variableStart, "").replace(this.variableEnd, ""), "");
        String variableValue = variable == null ? "" : String.valueOf(variable);
        this.replaceParagraph(paragraph, start, end, variableValue, this.variableEnd.length());
        this.replaceParagraph(paragraph, dataMap);
    }

    private void replaceTableParagraph(XWPFTable table, Map<String, Object> dataMap) {
        HashMap<Integer, XWPFTableRow> rowForLoop = new HashMap<Integer, XWPFTableRow>();
        HashMap replace = new HashMap();
        HashMap methodCache = new HashMap();
        AtomicInteger dataLength = new AtomicInteger(0);
        int[] index = new int[]{0, 0, 0};
        table.getRows().forEach(row -> {
            index[1] = 0;
            row.getTableCells().forEach(cell -> {
                String content = cell.getText();
                if (content.contains(this.loopStart) && content.contains(this.loopEnd) && !rowForLoop.containsKey(index[0])) {
                    rowForLoop.put(index[0], (XWPFTableRow)row);
                }
                Map map = replace.getOrDefault(index[1], new HashMap());
                replace.put(index[1], map);
                index[2] = 0;
                cell.getParagraphs().forEach(paragraph -> {
                    this.replaceParagraph((XWPFParagraph)paragraph, dataMap);
                    if (rowForLoop.containsKey(index[0])) {
                        List list = map.getOrDefault(index[2], new ArrayList());
                        int n = index[2];
                        index[2] = n + 1;
                        map.put(n, list);
                        this.searchLoopVariable((XWPFParagraph)paragraph, list, dataMap, methodCache, dataLength, new PositionInParagraph());
                    }
                });
                index[1] = index[1] + 1;
            });
            index[0] = index[0] + 1;
        });
        rowForLoop.forEach((pos, row) -> {
            index[0] = dataLength.intValue() - 1;
            while (index[0] > 0) {
                index[1] = 0;
                XWPFTableRow newRow = this.insertTableRow(pos + 1, (XWPFTableRow)row, table);
                newRow.getTableCells().forEach(cell -> {
                    index[2] = 0;
                    cell.getParagraphs().forEach(paragraph -> {
                        if (paragraph.getRuns().isEmpty()) {
                            return;
                        }
                        int n = index[2];
                        index[2] = n + 1;
                        ((List)((Map)replace.get(index[1])).get(n)).forEach(replacement -> this.replaceParagraph((XWPFParagraph)paragraph, replacement.getStart(), replacement.getEnd(), replacement.valueAt(index[0], dataMap), this.loopEnd.length()));
                    });
                    index[1] = index[1] + 1;
                });
                index[0] = index[0] - 1;
            }
            index[1] = 0;
            index[0] = 0;
            row.getTableCells().forEach(cell -> {
                index[2] = 0;
                cell.getParagraphs().forEach(paragraph -> {
                    int n = index[2];
                    index[2] = n + 1;
                    ((List)((Map)replace.get(index[1])).get(n)).forEach(replacement -> this.replaceParagraph((XWPFParagraph)paragraph, replacement.getStart(), replacement.getEnd(), replacement.valueAt(index[0], dataMap), this.loopEnd.length()));
                });
                index[1] = index[1] + 1;
            });
        });
    }

    private void replaceParagraph(XWPFParagraph paragraph, TextSegment start, TextSegment end, String variableValue, int variableEndLength) {
        List runs = paragraph.getRuns();
        XWPFRun runStart = (XWPFRun)runs.get(start.getBeginRun());
        XWPFRun runEnd = (XWPFRun)runs.get(end.getEndRun());
        String textBefore = runStart.text().substring(0, start.getBeginChar());
        String textAfter = runEnd.text().substring(end.getEndChar() + variableEndLength);
        StringBuilder builder = new StringBuilder();
        if (start.getBeginRun() == end.getEndRun()) {
            runStart.setText(builder.append(textBefore).append(variableValue).append(textAfter).toString(), 0);
        } else {
            runStart.setText(builder.append(textBefore).append(variableValue).toString(), 0);
            runEnd.setText(textAfter, 0);
            for (int pos = end.getEndRun(); pos > start.getBeginRun(); --pos) {
                paragraph.removeRun(pos);
            }
        }
    }

    private XWPFTableRow insertTableRow(int pos, XWPFTableRow row, XWPFTable table) {
        CTTbl ctTbl = table.getCTTbl();
        int sizeCol = ctTbl.sizeOfTrArray() > 0 ? ctTbl.getTrArray(0).sizeOfTcArray() : 0;
        XWPFTableRow newRow = table.insertNewTableRow(pos);
        newRow.getCtRow().setTrPr(row.getCtRow().getTrPr());
        for (int i = 0; i < sizeCol; ++i) {
            XWPFTableCell cell = newRow.createCell();
            cell.getCTTc().setTcPr(row.getCell(i).getCTTc().getTcPr());
            for (XWPFParagraph paragraph : row.getCell(i).getParagraphs()) {
                XWPFParagraph newParagraph = cell.addParagraph();
                newParagraph.getCTP().setPPr(paragraph.getCTP().getPPr());
                for (XWPFRun run : paragraph.getRuns()) {
                    XWPFRun newRun = newParagraph.createRun();
                    newRun.getCTR().setRPr(run.getCTR().getRPr());
                    newRun.setText(run.text());
                }
            }
        }
        return newRow;
    }

    private void searchLoopVariable(XWPFParagraph paragraph, List<Replacement> list, Map<String, Object> dataMap, Map<String, Map<String, Method>> methodCache, AtomicInteger dataLength, PositionInParagraph startPosition) {
        TextSegment start = paragraph.searchText(this.loopStart, startPosition);
        if (start == null) {
            return;
        }
        TextSegment end = paragraph.searchText(this.loopEnd, new PositionInParagraph(start.getEndRun(), start.getEndText(), start.getEndChar()));
        if (end == null) {
            return;
        }
        String variableKey = paragraph.getText(new TextSegment(start.getBeginRun(), end.getEndRun(), start.getBeginText(), end.getEndText(), start.getBeginChar(), end.getEndChar()));
        variableKey = variableKey.replace(this.loopStart, "").replace(this.loopEnd, "");
        Replacement replacement = new Replacement();
        replacement.setStart(start);
        replacement.setEnd(end);
        replacement.setIndexKey(variableKey);
        if (variableKey.contains(".")) {
            ArrayList curList;
            Object object;
            final String[] split = variableKey.split("\\.");
            replacement.setIndexKey(split[0]);
            if (methodCache.containsKey(split[0]) && methodCache.get(split[0]).containsKey(split[1])) {
                replacement.setMethod(methodCache.get(split[0]).get(split[1]));
            } else if (dataMap.containsKey(split[0]) && (object = dataMap.get(split[0])) instanceof ArrayList && !(curList = (ArrayList)object).isEmpty()) {
                dataLength.set(Math.max(dataLength.intValue(), curList.size()));
                object = curList.get(0);
                try {
                    final Method method = ClassUtils.methodGetterOf(split[1], object.getClass());
                    replacement.setMethod(method);
                    methodCache.put(split[0], (Map<String, Method>)new HashMap<String, Method>(){
                        {
                            this.put(split[1], method);
                        }
                    });
                }
                catch (NoSuchFieldException | NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }
        list.add(replacement);
        this.searchLoopVariable(paragraph, list, dataMap, methodCache, dataLength, new PositionInParagraph(end.getEndRun(), end.getEndText(), end.getEndChar()));
    }

    private class Replacement {
        private TextSegment start;
        private TextSegment end;
        private String indexKey;
        private Method method;

        private Replacement() {
        }

        public String valueAt(int index, Map<String, Object> ofData) {
            String value = "";
            if (this.isIndexValue()) {
                value = String.valueOf(index + 1);
            } else if (this.getMethod() != null) {
                try {
                    List list = (List)ofData.get(this.getIndexKey());
                    if (list != null && !list.isEmpty() && index < list.size()) {
                        value = String.valueOf(this.getMethod().invoke(list.get(index), new Object[0]));
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                    value = "";
                }
            }
            return value;
        }

        public boolean isIndexValue() {
            return "index".equals(this.indexKey);
        }

        public TextSegment getStart() {
            return this.start;
        }

        public void setStart(TextSegment start) {
            this.start = start;
        }

        public TextSegment getEnd() {
            return this.end;
        }

        public void setEnd(TextSegment end) {
            this.end = end;
        }

        public String getIndexKey() {
            return this.indexKey;
        }

        public void setIndexKey(String indexKey) {
            this.indexKey = indexKey;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }
    }
}

