/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import xyz.thepathfinder.android.Cluster;
import xyz.thepathfinder.android.ClusterListener;
import xyz.thepathfinder.android.CommodityListener;
import xyz.thepathfinder.android.CommodityStatus;
import xyz.thepathfinder.android.Pathfinder;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.Route;
import xyz.thepathfinder.android.SubscribableCrudModel;

public class Commodity
extends SubscribableCrudModel<CommodityListener> {
    private static final Logger logger = Logger.getLogger(Commodity.class.getName());
    private static final String MODEL = Pathfinder.COMMODITY;
    private double startLatitude;
    private double startLongitude;
    private double endLatitude;
    private double endLongitude;
    private CommodityStatus status;
    private JsonObject metadata;
    private Route route;

    protected Commodity(String path, PathfinderServices services) {
        super(path, services);
        logger.finest("Constructing commodity by path: " + path);
        boolean isRegistered = this.getServices().getRegistry().isModelRegistered(path);
        if (isRegistered) {
            logger.warning("Illegal Argument Exception: Commodity path already exists " + path);
            throw new IllegalArgumentException("Commodity path already exists: " + path);
        }
        this.getServices().getRegistry().registerModel(this);
        this.startLatitude = 0.0;
        this.startLongitude = 0.0;
        this.endLatitude = 0.0;
        this.endLongitude = 0.0;
        this.status = CommodityStatus.INACTIVE;
        this.metadata = new JsonObject();
        this.route = null;
    }

    protected Commodity(String path, double startLatitude, double startLongitude, double endLatitude, double endLongitude, CommodityStatus status, JsonObject metadata, PathfinderServices services) {
        this(path, services);
        logger.finest("Constructing commodity by parameters: " + path);
        this.startLatitude = startLatitude;
        this.startLongitude = startLongitude;
        this.endLatitude = endLatitude;
        this.endLongitude = endLongitude;
        this.status = status == null ? CommodityStatus.INACTIVE : status;
        this.metadata = metadata == null ? new JsonObject() : metadata;
        this.route = null;
    }

    protected static Commodity getInstance(String path, PathfinderServices services) {
        Commodity commodity = (Commodity)services.getRegistry().getModel(path);
        if (commodity == null) {
            return new Commodity(path, services);
        }
        logger.finest("Getting commodity instance: " + commodity);
        return commodity;
    }

    protected static Commodity getInstance(JsonObject commodityJson, PathfinderServices services) {
        if (!Commodity.checkCommodityFields(commodityJson)) {
            logger.warning("Illegal Argument Exception: JSON could not be parse to a commodity " + commodityJson);
            throw new IllegalArgumentException("JSON could not be parsed to a commodity " + commodityJson);
        }
        String path = Commodity.getPath(commodityJson);
        Commodity commodity = Commodity.getInstance(path, services);
        logger.finest("Notifying commodity of update: \nCurrent commodity: " + commodity + "\nNew JSON: " + commodityJson);
        commodity.notifyUpdate(null, commodityJson);
        return commodity;
    }

    private static boolean checkCommodityField(JsonObject commodityJson, String field) {
        return commodityJson.has(field);
    }

    private static boolean checkCommodityFields(JsonObject commodityJson) {
        return Commodity.checkCommodityField(commodityJson, "path") && Commodity.checkCommodityField(commodityJson, "startLatitude") && Commodity.checkCommodityField(commodityJson, "startLongitude") && Commodity.checkCommodityField(commodityJson, "endLatitude") && Commodity.checkCommodityField(commodityJson, "endLongitude") && Commodity.checkCommodityField(commodityJson, "status") && Commodity.checkCommodityField(commodityJson, "metadata") && commodityJson.get("metadata").isJsonObject();
    }

    private static String getPath(JsonObject commodityJson) {
        return commodityJson.get("path").getAsString();
    }

    public void updateStartLocation(double startLatitude, double startLongitude) {
        this.update(startLatitude, startLongitude, null, null, null, null);
    }

    public double getStartLatitude() {
        return this.startLatitude;
    }

    private void setStartLatitude(double latitude) {
        this.startLatitude = latitude;
    }

    public void updateStartLatitude(double startLatitude) {
        this.update(startLatitude, null, null, null, null, null);
    }

    public double getStartLongitude() {
        return this.startLongitude;
    }

    private void setStartLongitude(double longitude) {
        this.startLongitude = longitude;
    }

    public void updateStartLongitude(double startLongitude) {
        this.update(null, startLongitude, null, null, null, null);
    }

    public void updateEndLocation(double endLatitude, double endLongitude) {
        this.update(null, null, endLatitude, endLongitude, null, null);
    }

    public double getEndLatitude() {
        return this.endLatitude;
    }

    private void setEndLatitude(double latitude) {
        this.endLatitude = latitude;
    }

    public void updateEndLatitude(double endLatitude) {
        this.update(null, null, endLatitude, null, null, null);
    }

    public double getEndLongitude() {
        return this.endLongitude;
    }

    private void setEndLongitude(double longitude) {
        this.endLongitude = longitude;
    }

    public void updateEndLongitude(double endLongitude) {
        this.update(null, null, null, endLongitude, null, null);
    }

    public CommodityStatus getStatus() {
        return this.status;
    }

    private static CommodityStatus getStatus(String status) {
        CommodityStatus[] values = CommodityStatus.values();
        for (int k = 0; k < values.length; ++k) {
            if (!values[k].equals(status)) continue;
            return values[k];
        }
        return null;
    }

    private void setStatus(CommodityStatus status) {
        if (status == null) {
            logger.warning("Illegal Argument ExceptionL illegal commodity status: " + (Object)((Object)status));
            throw new IllegalArgumentException("Illegal status");
        }
        this.status = status;
    }

    private void setStatus(String status) {
        this.setStatus(Commodity.getStatus(status));
    }

    public void updateStatus(CommodityStatus status) {
        this.update(null, null, null, null, status, null);
    }

    public JsonObject getMetadata() {
        return this.metadata;
    }

    private void setMetadata(JsonObject metadata) {
        this.metadata = metadata == null ? new JsonObject() : metadata;
    }

    public void updateMetadata(JsonObject metadata) {
        this.update(null, null, null, null, null, metadata);
    }

    public Route getRoute() {
        return this.route;
    }

    private void setRoute(Route route) {
        this.route = route;
    }

    public void update(Double startLatitude, Double startLongitude, Double endLatitude, Double endLongitude, CommodityStatus status, JsonObject metadata) {
        JsonObject value = new JsonObject();
        if (startLatitude != null) {
            value.addProperty("startLatitude", (Number)startLatitude);
        }
        if (startLongitude != null) {
            value.addProperty("startLongitude", (Number)startLongitude);
        }
        if (endLatitude != null) {
            value.addProperty("endLatitude", (Number)endLatitude);
        }
        if (endLongitude != null) {
            value.addProperty("endLongitude", (Number)endLongitude);
        }
        if (status != null) {
            value.addProperty("status", status.toString());
        }
        if (metadata != null) {
            value.add("metadata", (JsonElement)metadata);
        }
        super.update(value);
    }

    @Override
    protected String getModel() {
        return MODEL;
    }

    @Override
    protected JsonObject createValueJson() {
        JsonObject json = new JsonObject();
        json.addProperty("path", this.getPath());
        json.addProperty("model", this.getModel());
        json.addProperty("startLatitude", (Number)this.getStartLatitude());
        json.addProperty("startLongitude", (Number)this.getStartLongitude());
        json.addProperty("endLatitude", (Number)this.getEndLatitude());
        json.addProperty("endLongitude", (Number)this.getEndLongitude());
        json.addProperty("status", this.getStatus().toString());
        json.add("metadata", (JsonElement)this.getMetadata());
        return json;
    }

    @Override
    protected boolean updateFields(JsonObject json) {
        boolean updated = false;
        double prevStartLatitude = this.getStartLatitude();
        if (json.has("startLatitude")) {
            this.setStartLatitude(json.get("startLatitude").getAsDouble());
        }
        double prevStartLongitude = this.getStartLongitude();
        if (json.has("startLongitude")) {
            this.setStartLongitude(json.get("startLongitude").getAsDouble());
        }
        double prevEndLatitude = this.getEndLatitude();
        if (json.has("endLatitude")) {
            this.setEndLatitude(json.get("endLatitude").getAsDouble());
        }
        double prevEndLongitude = this.getEndLongitude();
        if (json.has("endLongitude")) {
            this.setEndLongitude(json.get("endLongitude").getAsDouble());
        }
        CommodityStatus prevStatus = this.getStatus();
        if (json.has("status")) {
            this.setStatus(Commodity.getStatus(json.get("status").getAsString()));
        }
        JsonObject prevMetadata = this.getMetadata();
        if (json.has("metadata")) {
            this.setMetadata(json.get("metadata").getAsJsonObject());
        }
        List listeners = this.getListeners();
        if (this.getStartLatitude() != prevStartLatitude) {
            logger.finest("Commodity " + this.getPath() + " start latitude updated: " + this.getStartLatitude());
            for (CommodityListener listener : listeners) {
                listener.startLatitudeUpdated(this.getStartLatitude());
            }
            updated = true;
        }
        if (this.getEndLongitude() != prevStartLongitude) {
            logger.finest("Commodity " + this.getPath() + " start longitude updated: " + this.getStartLongitude());
            for (CommodityListener listener : listeners) {
                listener.startLongitudeUpdated(this.getStartLongitude());
            }
            updated = true;
        }
        if (this.getEndLatitude() != prevEndLatitude) {
            logger.finest("Commodity " + this.getPath() + " end latitude updated: " + this.getEndLatitude());
            for (CommodityListener listener : listeners) {
                listener.endLatitudeUpdated(this.getEndLatitude());
            }
            updated = true;
        }
        if (this.getEndLongitude() != prevEndLongitude) {
            logger.finest("Commodity " + this.getPath() + " end longitude updated: " + this.getEndLongitude());
            for (CommodityListener listener : listeners) {
                listener.endLongitudeUpdated(this.getEndLongitude());
            }
            updated = true;
        }
        if (!this.getStatus().equals((Object)prevStatus)) {
            logger.finest("Commodity " + this.getPath() + " status updated: " + (Object)((Object)this.getStatus()));
            for (CommodityListener listener : listeners) {
                listener.statusUpdated(this.getStatus());
            }
            updated = true;
        }
        if (!this.getMetadata().equals((Object)prevMetadata)) {
            logger.finest("Commodity " + this.getPath() + " metadata updated: " + this.getMetadata());
            for (CommodityListener listener : listeners) {
                listener.metadataUpdated(this.getMetadata());
            }
            updated = true;
        }
        String parentPath = this.getParentPath();
        if (updated && this.getServices().getRegistry().isModelRegistered(parentPath)) {
            Cluster parentCluster = Cluster.getInstance(parentPath, this.getServices());
            Collection<Commodity> commodities = parentCluster.getCommodities();
            logger.finest("Commodity " + this.getPath() + " calling parent cluster's update");
            List clusterListeners = parentCluster.getListeners();
            for (ClusterListener listener : clusterListeners) {
                listener.commodityUpdated(this);
                listener.commoditiesUpdated(commodities);
            }
        }
        return updated;
    }

    @Override
    protected void route(JsonObject json, PathfinderServices services) {
        JsonObject route = json.getAsJsonObject("value");
        logger.finest("Commodity setting route: " + this.getPath());
        this.setRoute(new Route(route, services));
        logger.finest("Commodity updating route: " + this.getPath());
        for (CommodityListener listener : this.getListeners()) {
            listener.routed(this.getRoute());
        }
    }

    public String toString() {
        JsonObject json = this.createValueJson();
        if (this.getRoute() != null) {
            json.addProperty("route", this.getRoute().toString());
        }
        return json.toString();
    }
}

