/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import java.io.IOException;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import xyz.thepathfinder.android.MessageHandler;
import xyz.thepathfinder.android.ModelRegistry;

class Connection
extends Endpoint {
    private final String applictionIdentifier;
    private final String userCredentials;
    private final ModelRegistry registry;
    private Session session;
    private long sentMessageCount;
    private MessageHandler messageHandler;
    private static final Logger logger = Logger.getLogger(Connection.class.getName());

    protected Connection(String applictionIdentifier, String userCredentials, ModelRegistry registry) {
        this.applictionIdentifier = applictionIdentifier;
        this.userCredentials = userCredentials;
        this.registry = registry;
        this.sentMessageCount = 0L;
    }

    public void sendMessage(String message) {
        logger.finest("Sending json to Pathfinder: " + message);
        if (this.isConnected()) {
            this.session.getAsyncRemote().sendText(message);
            ++this.sentMessageCount;
        } else {
            logger.warning("Illegal State Exception: The connection to Pathfinder is not open.");
            throw new IllegalStateException("The connection to Pathfinder is not open.");
        }
    }

    public void onOpen(Session session, EndpointConfig config) {
        logger.finest("Pathfinder connection opened");
        this.session = session;
        this.messageHandler = new MessageHandler(this.registry);
        this.session.addMessageHandler((javax.websocket.MessageHandler)this.messageHandler);
    }

    public void onClose(Session session, CloseReason closeReason) {
        logger.finest("Pathfinder connection closed: " + closeReason);
        this.session = session;
    }

    public boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }

    public long getSentMessageCount() {
        return this.sentMessageCount;
    }

    public long getReceivedMessageCount() {
        return this.messageHandler.getReceivedMessageCount();
    }

    public void close(CloseReason reason) throws IOException {
        this.session.close(reason);
    }
}

