/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import xyz.thepathfinder.android.Model;

class ModelRegistry {
    private static final Logger logger = Logger.getLogger(ModelRegistry.class.getName());
    private final Map<String, Model> models = new HashMap<String, Model>();

    protected ModelRegistry() {
    }

    protected void registerModel(Model model) {
        if (this.models.containsKey(model.getPath())) {
            logger.warning("Illegal State Exception: path already exists" + model.getPath());
            throw new IllegalStateException("Path already exists: " + model.getPath());
        }
        this.models.put(model.getPath(), model);
    }

    protected Model unregisterModel(String path) {
        return this.models.remove(path);
    }

    protected boolean isModelRegistered(String path) {
        return this.models.containsKey(path);
    }

    protected Model getModel(String path) {
        logger.info("Model requested: " + path);
        return this.models.get(path);
    }
}

