/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import java.util.logging.Logger;

class Path {
    private static final Logger logger = Logger.getLogger(Path.class.getName());
    private static final String PATH_SEPARATOR = "/";
    public static final String DEFAULT_PATH = "/default";
    private String path;

    protected Path(String path) {
        if (!Path.isValidPath(path)) {
            throw new IllegalArgumentException("Path cannot be an empty string");
        }
        this.path = path == null ? DEFAULT_PATH : path;
    }

    public static boolean isValidPath(String path) {
        return path == null || !path.equals("");
    }

    public static boolean isValidName(String name) {
        return !name.contains(PATH_SEPARATOR);
    }

    public String getChildPath(String name) {
        if (Path.isValidName(name)) {
            return this.path + PATH_SEPARATOR + name;
        }
        logger.warning("Illegal Argument Exception: Illegal path name " + name);
        throw new IllegalArgumentException("Illegal path name: " + name);
    }

    public String getName() {
        int lastSlashIndex = this.path.lastIndexOf(PATH_SEPARATOR) + 1;
        return this.path.substring(lastSlashIndex);
    }

    public String getPath() {
        return this.path;
    }

    public String getParentPath() {
        int lastSlashIndex = this.path.lastIndexOf(PATH_SEPARATOR);
        return this.path.substring(0, lastSlashIndex);
    }

    public boolean equals(Object o) {
        if (o instanceof Path) {
            Path otherPath = (Path)o;
            return this.path.equals(otherPath.path);
        }
        return false;
    }
}

