/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import xyz.thepathfinder.android.Action;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.Transport;

public class Route {
    private static final Logger logger = Logger.getLogger(Route.class.getName());
    private final Transport transport;
    private final List<Action> actions;

    protected Route(JsonObject routeJson, PathfinderServices services) {
        logger.finest("Parsing route: " + routeJson.toString());
        this.transport = Route.getTransport(routeJson, services);
        this.actions = Route.getActions(routeJson, services);
    }

    public Transport getTransport() {
        return this.transport;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    private static Transport getTransport(JsonObject json, PathfinderServices services) {
        logger.finest("Route getting transport: " + json.toString());
        return Transport.getInstance(json.getAsJsonObject("model"), services);
    }

    private static List<Action> getActions(JsonObject json, PathfinderServices services) {
        logger.finest("route getting actions: " + json.toString());
        JsonArray actions = json.getAsJsonArray("actions");
        ArrayList<Action> list = new ArrayList<Action>();
        for (JsonElement element : actions) {
            logger.finest("route adding action: " + element.toString());
            list.add(new Action(element.getAsJsonObject(), services));
        }
        return list;
    }

    public String toString() {
        JsonObject json = new JsonObject();
        json.addProperty("transport", this.getTransport().getPath());
        json.addProperty("actions", this.getActions().toString());
        return json.toString();
    }
}

