/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonObject;
import java.util.logging.Logger;
import xyz.thepathfinder.android.Listener;
import xyz.thepathfinder.android.Model;
import xyz.thepathfinder.android.PathfinderServices;

public abstract class SubscribableModel<E extends Listener<? extends Model>>
extends Model<E> {
    private static final Logger logger = Logger.getLogger(SubscribableModel.class.getName());

    public SubscribableModel(String path, PathfinderServices services) {
        super(path, services);
    }

    public JsonObject getMessageHeader(String type) {
        JsonObject json = new JsonObject();
        json.addProperty("message", type);
        json.addProperty("path", this.getPath());
        json.addProperty("model", this.getModel());
        return json;
    }

    public void subscribe() {
        if (!this.isConnected()) {
            logger.warning("Cannot subscribe to a model you are not connected to");
            throw new IllegalStateException("Not connected to object on Pathfinder server");
        }
        JsonObject json = this.getMessageHeader("Subscribe");
        this.getServices().getConnection().sendMessage(json.toString());
    }

    public void unsubscribe() {
    }

    public void routeSubscribe() {
        if (!this.isConnected()) {
            logger.warning("Cannot route subscribe to a model you are not connected to");
            throw new IllegalStateException("Not connected to object on Pathfinder server");
        }
        JsonObject json = this.getMessageHeader("RouteSubscribe");
        this.getServices().getConnection().sendMessage(json.toString());
    }

    public void routeUnsubscribe() {
    }
}

