/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import xyz.thepathfinder.android.Cluster;
import xyz.thepathfinder.android.ClusterListener;
import xyz.thepathfinder.android.Pathfinder;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.Route;
import xyz.thepathfinder.android.SubscribableCrudModel;
import xyz.thepathfinder.android.TransportListener;
import xyz.thepathfinder.android.TransportStatus;

public class Transport
extends SubscribableCrudModel<TransportListener> {
    private static final Logger logger = Logger.getLogger(Transport.class.getName());
    private static final String MODEL = Pathfinder.TRANSPORT;
    private double latitude;
    private double longitude;
    private TransportStatus status;
    private JsonObject metadata;
    private Route route;

    protected Transport(String path, PathfinderServices services) {
        super(path, services);
        logger.finest("Constructing transport by parameters: " + path);
        boolean isRegistered = this.getServices().getRegistry().isModelRegistered(path);
        if (isRegistered) {
            logger.warning("Illegal Argument Exception: Transport path already exists: " + path);
            throw new IllegalArgumentException("Transport path already exists: " + path);
        }
        this.getServices().getRegistry().registerModel(this);
        this.latitude = 0.0;
        this.longitude = 0.0;
        this.status = TransportStatus.OFFLINE;
        this.metadata = new JsonObject();
        this.route = null;
    }

    protected Transport(String path, double latitude, double longitude, TransportStatus status, JsonObject metadata, PathfinderServices services) {
        this(path, services);
        this.latitude = latitude;
        this.longitude = longitude;
        this.status = status == null ? TransportStatus.OFFLINE : status;
        this.metadata = metadata == null ? new JsonObject() : metadata;
        this.route = null;
    }

    public static Transport getInstance(String path, PathfinderServices services) {
        Transport transport = (Transport)services.getRegistry().getModel(path);
        if (transport == null) {
            return new Transport(path, services);
        }
        logger.finest("Getting transport instance: " + transport);
        return transport;
    }

    protected static Transport getInstance(JsonObject transportJson, PathfinderServices services) {
        if (!Transport.checkTransportFields(transportJson)) {
            logger.warning("Illegal Argument Exception: Invalid JSON cannot be parsed to a transport " + transportJson);
            throw new IllegalArgumentException("Invalid JSON cannot be parsed to a transport " + transportJson);
        }
        String path = Transport.getPath(transportJson);
        Transport transport = Transport.getInstance(path, services);
        logger.finest("Notifying transport of update: \nCurrent transport: " + transport + "\nNew JSON: " + transportJson);
        transport.notifyUpdate(null, transportJson);
        return transport;
    }

    private static boolean checkTransportField(JsonObject transportJson, String field) {
        return transportJson.has(field);
    }

    private static boolean checkTransportFields(JsonObject transportJson) {
        return Transport.checkTransportField(transportJson, "path") && Transport.checkTransportField(transportJson, "latitude") && Transport.checkTransportField(transportJson, "longitude") && Transport.checkTransportField(transportJson, "status") && Transport.checkTransportField(transportJson, "metadata") && !transportJson.get("metadata").isJsonObject();
    }

    private static String getPath(JsonObject transportJson) {
        return transportJson.get("path").getAsString();
    }

    public void updateLocation(double latitude, double longitude) {
        this.update(latitude, longitude, null, null);
    }

    public Double getLatitude() {
        return this.latitude;
    }

    private void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void updateLatitude(double latitude) {
        this.update(latitude, null, null, null);
    }

    public Double getLongitude() {
        return this.longitude;
    }

    private void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void updateLongitude(double longitude) {
        this.update(null, longitude, null, null);
    }

    public TransportStatus getStatus() {
        return this.status;
    }

    private void setStatus(TransportStatus status) {
        this.status = status;
    }

    private static TransportStatus getStatus(String status) {
        TransportStatus[] values;
        for (TransportStatus value : values = TransportStatus.values()) {
            if (!value.equals(status)) continue;
            return value;
        }
        return null;
    }

    public void updateStatus(TransportStatus status) {
        this.update(null, null, status, null);
    }

    public JsonObject getMetadata() {
        return this.metadata;
    }

    private void setMetadata(JsonObject metadata) {
        this.metadata = metadata == null ? new JsonObject() : metadata;
    }

    public void updateMetadata(JsonObject metadata) {
        this.update(null, null, null, metadata);
    }

    public Route getRoute() {
        return this.route;
    }

    private void setRoute(Route route) {
        this.route = route;
    }

    public void update(Double latitude, Double longitude, TransportStatus status, JsonObject metadata) {
        JsonObject value = new JsonObject();
        if (latitude != null) {
            value.addProperty("latitude", (Number)latitude);
        }
        if (longitude != null) {
            value.addProperty("longitude", (Number)longitude);
        }
        if (status != null) {
            value.addProperty("status", status.toString());
        }
        if (metadata != null) {
            value.add("metadata", (JsonElement)metadata);
        }
        super.update(value);
    }

    @Override
    protected String getModel() {
        return MODEL;
    }

    @Override
    protected JsonObject createValueJson() {
        JsonObject json = new JsonObject();
        json.addProperty("path", this.getPath());
        json.addProperty("model", this.getModel());
        json.addProperty("latitude", (Number)this.getLatitude());
        json.addProperty("longitude", (Number)this.getLongitude());
        json.addProperty("status", this.getStatus().toString());
        json.add("metadata", (JsonElement)this.getMetadata());
        return json;
    }

    @Override
    protected boolean updateFields(JsonObject json) {
        boolean updated = false;
        double prevLatitude = this.getLatitude();
        if (json.has("latitude")) {
            this.setLatitude(json.get("latitude").getAsDouble());
        }
        double prevLongitude = this.getLongitude();
        if (json.has("longitude")) {
            this.setLongitude(json.get("longitude").getAsDouble());
        }
        TransportStatus prevStatus = this.getStatus();
        if (json.has("status")) {
            this.setStatus(Transport.getStatus(json.get("status").getAsString()));
        }
        JsonObject prevMetadata = this.getMetadata();
        if (json.has("metadata")) {
            this.setMetadata(json.get("metadata").getAsJsonObject());
        }
        List listeners = this.getListeners();
        if (this.getLatitude() != prevLatitude) {
            logger.finest("Transport " + this.getPath() + " latitude updated: " + this.getMetadata());
            for (TransportListener listener : listeners) {
                listener.latitudeUpdated(this.getLatitude());
            }
            updated = true;
        }
        if (this.getLongitude() != prevLongitude) {
            logger.finest("Transport " + this.getPath() + " longitude updated: " + this.getMetadata());
            for (TransportListener listener : listeners) {
                listener.longitudeUpdated(this.getLongitude());
            }
            updated = true;
        }
        if (this.getStatus().equals((Object)prevStatus)) {
            logger.finest("Transport " + this.getPath() + " status updated: " + this.getMetadata());
            for (TransportListener listener : listeners) {
                listener.statusUpdated(this.getStatus());
            }
            updated = true;
        }
        if (this.getMetadata().equals((Object)prevMetadata)) {
            logger.finest("Transport " + this.getPath() + " metadata updated: " + this.getMetadata());
            for (TransportListener listener : listeners) {
                listener.metadataUpdated(this.getMetadata());
            }
            updated = true;
        }
        String parentPath = this.getParentPath();
        if (updated && this.getServices().getRegistry().isModelRegistered(parentPath)) {
            Cluster parentCluster = Cluster.getInstance(parentPath, this.getServices());
            Collection<Transport> transports = parentCluster.getTransports();
            logger.finest("Transport " + this.getPath() + " calling parent cluster's update");
            List clusterListeners = parentCluster.getListeners();
            for (ClusterListener listener : clusterListeners) {
                listener.transportUpdated(this);
                listener.transportsUpdated(transports);
            }
        }
        return updated;
    }

    @Override
    protected void route(JsonObject json, PathfinderServices services) {
        JsonObject route = json.getAsJsonObject("value");
        logger.finest("Transport setting route: " + this.getPath());
        this.route = new Route(route, services);
        logger.finest("Transport updating route: " + this.getPath());
        for (TransportListener listener : this.getListeners()) {
            listener.routed(this.getRoute());
        }
    }

    public String toString() {
        JsonObject json = this.createValueJson();
        if (this.route != null) {
            json.addProperty("route", this.route.toString());
        }
        return json.toString();
    }
}

