/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.thepathfinder.android.ActionStatus;
import xyz.thepathfinder.android.Commodity;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.SubscribableCrudModel;

public class Action {
    private static final Logger logger = Logger.getLogger(Action.class.getName());
    private final ActionStatus status;
    private final double latitude;
    private final double longitude;
    private final SubscribableCrudModel model;

    protected Action(JsonObject actionJson, PathfinderServices services) {
        logger.info("Constructing action: " + actionJson.toString());
        this.status = Action.getStatus(actionJson);
        this.latitude = Action.getLatitude(actionJson);
        this.longitude = Action.getLongitude(actionJson);
        this.model = !this.status.equals((Object)ActionStatus.START) ? Action.getModel(actionJson, services) : null;
        logger.info("Done constructing action: " + this.toString());
    }

    public ActionStatus getStatus() {
        return this.status;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public SubscribableCrudModel getModel() {
        return this.model;
    }

    private static ActionStatus getStatus(JsonObject json) {
        return Action.getStatus(json.get("action").getAsString());
    }

    private static ActionStatus getStatus(String status) {
        ActionStatus[] values = ActionStatus.values();
        for (int k = 0; k < values.length; ++k) {
            if (!values[k].equals(status)) continue;
            return values[k];
        }
        return null;
    }

    private static double getLatitude(JsonObject json) {
        return json.get("latitude").getAsDouble();
    }

    private static double getLongitude(JsonObject json) {
        return json.get("longitude").getAsDouble();
    }

    private static SubscribableCrudModel getModel(JsonObject json, PathfinderServices services) {
        JsonObject model = json.getAsJsonObject("commodity");
        return Commodity.getInstance(model, services);
    }

    public String toString() {
        JsonObject json = new JsonObject();
        json.addProperty("latitude", (Number)this.getLatitude());
        json.addProperty("longitude", (Number)this.getLongitude());
        json.addProperty("status", this.getStatus().toString());
        if (this.getModel() != null) {
            json.addProperty("model", this.getModel().getPathName());
        }
        return json.toString();
    }

    static {
        logger.setLevel(Level.INFO);
    }
}

