/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.thepathfinder.android.ClusterListener;
import xyz.thepathfinder.android.Commodity;
import xyz.thepathfinder.android.CommodityStatus;
import xyz.thepathfinder.android.ModelType;
import xyz.thepathfinder.android.Path;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.Route;
import xyz.thepathfinder.android.SubscribableCrudModel;
import xyz.thepathfinder.android.Transport;
import xyz.thepathfinder.android.TransportListener;
import xyz.thepathfinder.android.TransportStatus;

public class Cluster
extends SubscribableCrudModel<ClusterListener> {
    private static final Logger logger = Logger.getLogger(Cluster.class.getName());
    private Map<String, Commodity> commodities;
    private Map<String, Cluster> subclusters;
    private Map<String, Transport> transports;
    private List<Route> routes;

    private Cluster(String path, PathfinderServices services) {
        super(path, ModelType.CLUSTER, services);
        logger.info("Constructing cluster by path: " + path);
        boolean isRegistered = this.getServices().getRegistry().isModelRegistered(new Path(path, ModelType.CLUSTER));
        if (isRegistered) {
            logger.severe("Illegal Argument Exception: Constructing cluster with path that already exists: " + path);
            throw new IllegalArgumentException("Cluster path already exists: " + path);
        }
        this.getServices().getRegistry().registerModel(this);
        this.transports = new HashMap<String, Transport>();
        this.commodities = new HashMap<String, Commodity>();
        this.subclusters = new HashMap<String, Cluster>();
        this.routes = new ArrayList<Route>();
        logger.info("Done constructing cluster by path: " + this);
    }

    protected static Cluster getInstance(String path, PathfinderServices services) {
        Cluster cluster = (Cluster)services.getRegistry().getModel(new Path(path, ModelType.CLUSTER));
        if (cluster == null && Path.isValidPath(path)) {
            cluster = new Cluster(path, services);
        }
        logger.info("Finished getting cluster instance: " + cluster);
        return cluster;
    }

    protected static Cluster getInstance(JsonObject clusterJson, PathfinderServices services) {
        boolean canParseToCluster = Cluster.checkClusterFields(clusterJson);
        if (!canParseToCluster) {
            logger.severe("Illegal Argument Exception: JSON could not be parsed to a cluster: " + clusterJson);
            throw new IllegalArgumentException("JSON could not be parsed to a cluster");
        }
        String path = Cluster.getPath(clusterJson);
        Cluster cluster = Cluster.getInstance(path, services);
        logger.info("Notifying cluster of update: \nCurrent cluster: " + cluster + "\nNew JSON: " + clusterJson);
        cluster.notifyUpdate(null, clusterJson);
        return cluster;
    }

    private static boolean checkClusterFields(JsonObject clusterJson) {
        return clusterJson.has("id") && clusterJson.has("vehicles") && clusterJson.get("vehicles").isJsonArray() && clusterJson.has("commodities") && clusterJson.get("commodities").isJsonArray() && clusterJson.has("subClusters") && clusterJson.get("subClusters").isJsonArray();
    }

    private static String getPath(JsonObject clusterJson) {
        return clusterJson.get("id").getAsString();
    }

    public void createCommodity(double startLatitude, double startLongitude, double endLatitude, double endLongitude, CommodityStatus status, JsonObject metadata) {
        if (!this.isConnected()) {
            logger.warning("Attempting to create a commodity on an unconnected cluster, request will fail if " + this.getPathName() + " is not found.");
        }
        JsonObject json = new JsonObject();
        json.addProperty("clusterId", this.getPathName());
        json.addProperty("model", ModelType.COMMODITY.toString());
        json.addProperty("startLatitude", (Number)startLatitude);
        json.addProperty("startLongitude", (Number)startLongitude);
        json.addProperty("endLatitude", (Number)endLatitude);
        json.addProperty("endLongitude", (Number)endLongitude);
        json.addProperty("status", status.toString());
        json.add("metadata", (JsonElement)metadata);
        this.create(json);
    }

    protected void addCommodity(Commodity commodity) {
        this.commodities.put(commodity.getPathName(), commodity);
    }

    private Commodity createCommodity(JsonObject commodityJson) {
        return Commodity.getInstance(commodityJson, this.getServices());
    }

    public Commodity getCommodity(String name) {
        return this.commodities.get(this.getChildPath(name, ModelType.COMMODITY).getPathName());
    }

    public Collection<Commodity> getCommodities() {
        return Collections.unmodifiableCollection(this.commodities.values());
    }

    public Map<String, Commodity> getCommoditiesMap() {
        return Collections.unmodifiableMap(this.commodities);
    }

    private void setCommodities(Iterable<Commodity> commodities) {
        for (Commodity commodity : commodities) {
            this.commodities.put(commodity.getPathName(), commodity);
        }
    }

    private void setCommodities(Map<String, Commodity> commodities) {
        this.commodities = commodities;
    }

    public void createSubcluster(String name) {
        if (!this.isConnected()) {
            logger.warning("Attempting to create a subcluster on an unconnected cluster, request will fail if " + this.getPathName() + " is not found.");
        }
        JsonObject json = new JsonObject();
        json.addProperty("id", this.getChildPath(name, ModelType.CLUSTER).getPathName());
        json.addProperty("model", ModelType.CLUSTER.toString());
        this.create(json);
    }

    public Cluster getSubcluster(String name) {
        return this.subclusters.get(this.getChildPath(name, ModelType.CLUSTER).getPathName());
    }

    public Collection<Cluster> getSubclusters() {
        return Collections.unmodifiableCollection(this.subclusters.values());
    }

    public Map<String, Cluster> getSubclustersMap() {
        return Collections.unmodifiableMap(this.subclusters);
    }

    private void setSubclusters(Iterable<Cluster> subclusters) {
        for (Cluster cluster : subclusters) {
            this.subclusters.put(cluster.getPathName(), cluster);
        }
    }

    private void setSubclusters(Map<String, Cluster> subclusters) {
        this.subclusters = subclusters;
    }

    protected void addTransport(Transport transport) {
        this.transports.put(transport.getPathName(), transport);
    }

    public void createTransport(String name, double latitude, double longitude, TransportStatus status, JsonObject metadata) {
        if (!this.isConnected()) {
            logger.warning("Attempting to create a transport on an unconnected cluster, request will fail if " + this.getPathName() + " is not found.");
        }
        JsonObject json = new JsonObject();
        json.addProperty("clusterId", this.getPathName());
        json.addProperty("model", ModelType.TRANSPORT.toString());
        json.addProperty("latitude", (Number)latitude);
        json.addProperty("longitude", (Number)longitude);
        json.addProperty("status", status.toString());
        json.add("metadata", (JsonElement)metadata);
        this.create(json);
    }

    private Transport createTransport(JsonObject transportJson) {
        return Transport.getInstance(transportJson, this.getServices());
    }

    public Transport getTransport(String name) {
        return this.transports.get(this.getChildPath(name, ModelType.TRANSPORT).getPathName());
    }

    public Collection<Transport> getTransports() {
        return Collections.unmodifiableCollection(this.transports.values());
    }

    public Map<String, Transport> getTransportsMap() {
        return Collections.unmodifiableMap(this.transports);
    }

    private void setTransports(Iterable<Transport> transports) {
        for (Transport transport : transports) {
            this.transports.put(transport.getPathName(), transport);
        }
    }

    private void setTransports(Map<String, Transport> transports) {
        this.transports = transports;
    }

    private void setRoutes(List<Route> routes) {
        this.routes = routes;
    }

    public Collection<Route> getRoutes() {
        return Collections.unmodifiableCollection(this.routes);
    }

    @Override
    protected JsonObject createValueJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.getPathName());
        json.addProperty("model", this.getModelType().toString());
        return json;
    }

    private String getSubmodelPath(JsonObject json) {
        String path = json.get("clusterId").getAsString();
        return path + "/" + json.get("id").getAsString();
    }

    @Override
    protected boolean updateFields(JsonObject json) {
        Commodity commodity;
        Cluster cluster;
        Transport transport;
        ArrayList<Commodity> updatedCommodities = new ArrayList<Commodity>();
        ArrayList<Cluster> updatedClusters = new ArrayList<Cluster>();
        ArrayList<Transport> updatedTransports = new ArrayList<Transport>();
        logger.info("Updating Cluster " + this.getPathName() + " with: " + json.toString());
        boolean updated = false;
        Map<String, Commodity> prevCommodities = this.getCommoditiesMap();
        HashMap<String, Commodity> commodityMap = new HashMap<String, Commodity>();
        if (json.has("commodities")) {
            JsonArray commodities = json.getAsJsonArray("commodities");
            for (JsonElement commodityJson : commodities) {
                String path = this.getSubmodelPath((JsonObject)commodityJson);
                Commodity commodity2 = Commodity.getInstance(path, this.getServices());
                if (commodity2.notifyUpdate(null, (JsonObject)commodityJson)) {
                    logger.info("Finished notifyUpdate in Cluster of commodity");
                    updatedCommodities.add(commodity2);
                }
                commodityMap.put(commodity2.getPathName(), commodity2);
            }
        }
        logger.info("Finished has commodities");
        Map<String, Transport> prevTransports = this.getTransportsMap();
        HashMap<String, Transport> transportMap = new HashMap<String, Transport>();
        if (json.has("vehicles")) {
            JsonArray transports = json.getAsJsonArray("vehicles");
            for (JsonElement transportJson : transports) {
                String path = this.getSubmodelPath((JsonObject)transportJson);
                transport = Transport.getInstance(path, this.getServices());
                if (transport.notifyUpdate(null, (JsonObject)transportJson)) {
                    updatedTransports.add(transport);
                }
                transportMap.put(transport.getPathName(), transport);
            }
        }
        Map<String, Cluster> prevSubclusters = this.getSubclustersMap();
        HashMap<String, Cluster> clusterMap = new HashMap<String, Cluster>();
        if (json.has("subClusters")) {
            JsonArray clusters = json.getAsJsonArray("subClusters");
            for (JsonElement clusterJson : clusters) {
                String path = this.getSubmodelPath((JsonObject)clusterJson);
                Cluster cluster2 = Cluster.getInstance(path, this.getServices());
                if (cluster2.notifyUpdate(null, (JsonObject)clusterJson)) {
                    updatedClusters.add(cluster2);
                }
                clusterMap.put(cluster2.getPathName(), cluster2);
            }
        }
        this.setCommodities(commodityMap);
        this.setSubclusters(clusterMap);
        this.setTransports(transportMap);
        List listeners = this.getListeners();
        for (String path : clusterMap.keySet()) {
            if (!prevSubclusters.containsKey(path)) {
                cluster = (Cluster)clusterMap.get(path);
                logger.info("Cluster " + this.getPathName() + " subcluster added: " + cluster.getPathName());
                for (ClusterListener listener : listeners) {
                    listener.subclusterAdded(cluster);
                }
            }
            updated = true;
        }
        for (String path : commodityMap.keySet()) {
            if (!prevCommodities.containsKey(path)) {
                commodity = (Commodity)commodityMap.get(path);
                logger.info("Cluster " + this.getPathName() + " commodity added: " + commodity.getPathName());
                for (ClusterListener listener : listeners) {
                    listener.commodityAdded(commodity);
                }
            }
            updated = true;
        }
        for (String path : transportMap.keySet()) {
            if (!prevTransports.containsKey(path)) {
                transport = (Transport)transportMap.get(path);
                logger.info("Cluster " + this.getPathName() + " transport added: " + transport.getPathName());
                for (ClusterListener listener : listeners) {
                    listener.transportAdded(transport);
                }
            }
            updated = true;
        }
        for (String path : prevCommodities.keySet()) {
            if (!commodityMap.containsKey(path)) {
                commodity = prevCommodities.get(path);
                logger.info("Cluster " + this.getPathName() + " commodity removed: " + commodity.getPathName());
                for (ClusterListener listener : listeners) {
                    listener.commodityRemoved(commodity);
                }
            }
            updated = true;
        }
        for (String path : prevSubclusters.keySet()) {
            if (!clusterMap.containsKey(path)) {
                cluster = prevSubclusters.get(path);
                logger.info("Cluster " + this.getPathName() + " subcluster removed: " + cluster.getPathName());
                for (ClusterListener listener : listeners) {
                    listener.subclusterRemoved(cluster);
                }
            }
            updated = true;
        }
        for (String path : prevTransports.keySet()) {
            if (!transportMap.containsKey(path)) {
                transport = prevTransports.get(path);
                logger.info("Cluster " + this.getPathName() + " transport removed: " + transport.getPathName());
                for (ClusterListener listener : listeners) {
                    listener.transportRemoved(transport);
                }
            }
            updated = true;
        }
        for (Cluster cluster3 : updatedClusters) {
            logger.info("Cluster " + this.getPathName() + " subcluster updated: " + cluster3.getPathName());
            for (ClusterListener listener : listeners) {
                listener.subclusterUpdated(cluster3);
            }
            updated = true;
        }
        for (Commodity commodity2 : updatedCommodities) {
            logger.info("Cluster " + this.getPathName() + " commodity updated: " + commodity2.getPathName());
            for (ClusterListener listener : listeners) {
                listener.commodityUpdated(commodity2);
            }
            updated = true;
        }
        for (Transport transport2 : updatedTransports) {
            logger.info("Cluster " + this.getPathName() + " transport updated: " + transport2.getPathName());
            for (ClusterListener listener : listeners) {
                listener.transportUpdated(transport2);
            }
            updated = true;
        }
        if (!updatedCommodities.isEmpty()) {
            logger.info("Cluster " + this.getPathName() + " commodities updated " + this.getCommodities());
            for (ClusterListener listener : listeners) {
                listener.commoditiesUpdated(this.getCommodities());
            }
        }
        if (!updatedClusters.isEmpty()) {
            logger.info("Cluster " + this.getPathName() + " subclusters updated " + this.getSubclusters());
            for (ClusterListener listener : listeners) {
                listener.subclustersUpdated(this.getSubclusters());
            }
        }
        if (!updatedTransports.isEmpty()) {
            logger.info("Cluster " + this.getPathName() + " transports updated " + this.getTransports());
            for (ClusterListener listener : listeners) {
                listener.transportsUpdated(this.getTransports());
            }
        }
        Path parentPath = this.getParentPath();
        if (updated && this.getServices().getRegistry().isModelRegistered(parentPath)) {
            Cluster parentCluster = Cluster.getInstance(parentPath.getPathName(), this.getServices());
            Collection<Cluster> clusters = parentCluster.getSubclusters();
            List clusterListeners = parentCluster.getListeners();
            logger.info("Cluster " + this.getPathName() + " calling parent cluster's update");
            for (ClusterListener listener : clusterListeners) {
                listener.subclusterUpdated(this);
                listener.subclustersUpdated(clusters);
            }
        }
        return updated;
    }

    @Override
    protected void route(JsonObject json, PathfinderServices services) {
        JsonArray routesJson = json.getAsJsonArray("route");
        ArrayList<Route> routes = new ArrayList<Route>();
        logger.info("Cluster adding routes: " + this.getPathName());
        for (JsonElement jsonElement : routesJson) {
            routes.add(new Route((JsonObject)jsonElement, services));
        }
        this.setRoutes(routes);
        for (Route route : this.getRoutes()) {
            Transport transport = route.getTransport();
            transport.setRoute(route);
            for (TransportListener listener : transport.getListeners()) {
                listener.routed(route);
                listener.updated(transport);
            }
        }
        logger.info("Cluster updating routes: " + this.getPathName());
        for (ClusterListener clusterListener : this.getListeners()) {
            clusterListener.routed(new ArrayList<Route>(this.getRoutes()));
        }
    }

    public String toString() {
        JsonObject json = new JsonObject();
        json.addProperty("path", this.getPathName());
        json.addProperty("commodities", this.getCommodities().toString());
        json.addProperty("subclusters", this.getSubclusters().toString());
        json.addProperty("transports", this.getTransports().toString());
        json.addProperty("routes", this.getRoutes().toString());
        return json.toString();
    }

    static {
        logger.setLevel(Level.INFO);
    }
}

