/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import xyz.thepathfinder.android.MessageHandler;
import xyz.thepathfinder.android.PathfinderServices;

class Connection
extends Endpoint {
    private final String userCredentials;
    private PathfinderServices services;
    private Session session;
    private long sentMessageCount;
    private MessageHandler messageHandler;
    private static final Logger logger = Logger.getLogger(Connection.class.getName());

    protected Connection(String userCredentials) {
        this.userCredentials = userCredentials;
        this.sentMessageCount = 0L;
    }

    protected void setServices(PathfinderServices services) {
        this.services = services;
        this.messageHandler.setServices(this.services);
    }

    public void sendMessage(String message) {
        logger.info("Sending json to Pathfinder: " + message);
        if (this.isConnected()) {
            this.session.getAsyncRemote().sendText(message);
            ++this.sentMessageCount;
        } else {
            logger.severe("Illegal State Exception: The connection to Pathfinder is not open.");
            throw new IllegalStateException("The connection to Pathfinder is not open.");
        }
    }

    public void onOpen(Session session, EndpointConfig config) {
        logger.info("Pathfinder connection opened");
        this.session = session;
        this.messageHandler = new MessageHandler(this.services);
        this.session.addMessageHandler((javax.websocket.MessageHandler)this.messageHandler);
    }

    public void onClose(Session session, CloseReason closeReason) {
        logger.info("Pathfinder connection closed: " + closeReason);
        this.session = session;
    }

    public boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }

    public long getSentMessageCount() {
        return this.sentMessageCount;
    }

    public long getReceivedMessageCount() {
        return this.messageHandler.getReceivedMessageCount();
    }

    public void close(CloseReason reason) throws IOException {
        this.session.close(reason);
    }

    static {
        logger.setLevel(Level.INFO);
    }
}

