/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.MessageHandler;
import xyz.thepathfinder.android.Cluster;
import xyz.thepathfinder.android.Commodity;
import xyz.thepathfinder.android.Model;
import xyz.thepathfinder.android.ModelType;
import xyz.thepathfinder.android.Path;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.Transport;

class MessageHandler
implements MessageHandler.Whole<String> {
    private static final Logger logger = Logger.getLogger(MessageHandler.class.getName());
    private PathfinderServices services;
    private int receivedMessageCount;

    protected MessageHandler(PathfinderServices services) {
        this.services = services;
        this.receivedMessageCount = 0;
    }

    protected void setServices(PathfinderServices services) {
        this.services = services;
    }

    public void onMessage(String message) {
        try {
            logger.info("Received json: " + message);
            ++this.receivedMessageCount;
            JsonObject json = new JsonParser().parse(message).getAsJsonObject();
            if (!json.has("message") || !json.has("model")) {
                logger.warning("Ignoring invalid message: " + json.toString());
            } else {
                String type = json.get("message").getAsString();
                JsonObject value = json.getAsJsonObject("value");
                String paths = "";
                if (json.has("id")) {
                    paths = paths + json.get("id").getAsString();
                } else if (json.has("clusterId")) {
                    paths = paths + json.get("clusterId").getAsString();
                } else if (!json.get("model").getAsString().equals(ModelType.CLUSTER.toString())) {
                    paths = paths + value.get("clusterId").getAsString();
                    paths = paths + "/" + value.get("id").getAsString();
                } else {
                    paths = paths + value.get("id").getAsString();
                }
                ModelType modelType = ModelType.getModelType(json.get("model").getAsString());
                logger.info("Model Type : " + (Object)((Object)modelType));
                Path path = new Path(paths, modelType);
                Model model = this.services.getRegistry().getModel(path);
                if (model != null) {
                    logger.info("Notifying " + model.getPathName() + " Type: " + (Object)((Object)model.getModelType()) + " of message");
                    model.notifyUpdate(type, json);
                } else {
                    Path parentPath = path.getParentPath();
                    if (parentPath != null && this.services.getRegistry().isModelRegistered(parentPath)) {
                        if (modelType == ModelType.CLUSTER) {
                            Cluster.getInstance(value, this.services);
                            return;
                        }
                        if (modelType == ModelType.COMMODITY) {
                            Commodity.getInstance(value, this.services);
                            return;
                        }
                        if (modelType == ModelType.TRANSPORT) {
                            Transport.getInstance(value, this.services);
                            return;
                        }
                    }
                    logger.warning("Received message that couldn't be routed to a model: " + message);
                }
            }
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            e.printStackTrace();
        }
    }

    public int getReceivedMessageCount() {
        return this.receivedMessageCount;
    }

    static {
        logger.setLevel(Level.INFO);
    }
}

