/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.thepathfinder.android.Cluster;
import xyz.thepathfinder.android.Listenable;
import xyz.thepathfinder.android.Listener;
import xyz.thepathfinder.android.ModelType;
import xyz.thepathfinder.android.Path;
import xyz.thepathfinder.android.PathfinderServices;

public abstract class Model<E extends Listener<? extends Model>>
extends Listenable<E> {
    private static final Logger logger = Logger.getLogger(Model.class.getName());
    private final Path path;
    private final PathfinderServices services;
    private boolean isConnected;

    public Model(String path, ModelType type, PathfinderServices services) {
        this.path = new Path(path, type);
        this.services = services;
        this.isConnected = false;
    }

    protected Path getPath() {
        return this.path;
    }

    public String getPathName() {
        return this.path.getPathName();
    }

    protected Path getChildPath(String name, ModelType type) {
        return this.path.getChildPath(name, type);
    }

    public Path getParentPath() {
        return this.path.getParentPath();
    }

    public Cluster getParentCluster() {
        Path parentPath = this.getParentPath();
        return Cluster.getInstance(parentPath.getPathName(), this.services);
    }

    public ModelType getModelType() {
        return this.path.getModelType();
    }

    protected PathfinderServices getServices() {
        return this.services;
    }

    protected void setConnected(boolean connected) {
        this.isConnected = connected;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    private boolean updateType(String reason, JsonObject json) {
        boolean updated = false;
        JsonObject value = null;
        logger.info("Reason for update is: " + reason + ", " + json);
        if (json.has("value") && !json.has("route")) {
            value = json.getAsJsonObject("value");
        } else if (reason == null) {
            value = json;
        }
        logger.info("Value is: " + value);
        if (value != null) {
            updated = this.updateFields(value);
        }
        logger.info("Finished updating " + this.getPathName() + "'s fields.");
        List listeners = this.getListeners();
        if (updated && !"Updated".equals(reason)) {
            logger.info("Model " + this.getPathName() + " updated");
            for (Listener listener : listeners) {
                logger.info("Calling updated");
                listener.updated(this);
                logger.info("Finished Calling updated");
            }
        }
        logger.info("Reason: " + reason);
        if (reason == null) {
            return updated;
        }
        if (reason.equals("Updated")) {
            logger.info("Model " + this.getPathName() + " updated");
            for (Listener listener : listeners) {
                listener.updated(this);
            }
            return updated;
        }
        if (reason.equals("Routed")) {
            logger.info("Model " + this.getPathName() + " routed");
            this.route(json, this.getServices());
            return true;
        }
        if (reason.equals("Model")) {
            logger.info("Model " + this.getPathName() + " connected");
            for (Listener listener : listeners) {
                listener.connected(this);
            }
            return updated;
        }
        if (reason.equals("Subscribed")) {
            logger.info("Model " + this.getPathName() + " subscribed");
            for (Listener listener : listeners) {
                listener.subscribed(this);
            }
            return updated;
        }
        if (reason.equals("RouteSubscribed")) {
            logger.info("Model " + this.getPathName() + " route subscribed");
            for (Listener listener : listeners) {
                listener.routeSubscribed(this);
            }
            return updated;
        }
        if (reason.equals("Unsubscribed")) {
            logger.info("Model " + this.getPathName() + " unsubscribed");
            for (Listener listener : listeners) {
                listener.unsubscribed(this);
            }
            return updated;
        }
        if (reason.equals("RouteUnsubscribed")) {
            logger.info("Model " + this.getPathName() + " route unsubscribed");
            for (Listener listener : listeners) {
                listener.routeUnsubscribed(this);
            }
            return updated;
        }
        if (reason.equals("Created")) {
            logger.info("Model " + this.getPathName() + " created");
            for (Listener listener : listeners) {
                listener.created(this);
            }
            return updated;
        }
        if (reason.equals("Deleted")) {
            logger.info("Model " + this.getPathName() + " deleted");
            for (Listener listener : listeners) {
                this.setConnected(false);
                listener.deleted(this);
            }
            return updated;
        }
        if (reason.equals("Error") && value != null) {
            logger.warning("Model " + this.getPathName() + " received error: " + value.get("reason").getAsString());
            for (Listener listener : listeners) {
                listener.error(value.get("reason").getAsString());
            }
            return updated;
        }
        logger.warning("Invalid message sent to " + this.getPathName() + " with type: " + reason + "\nJson: " + json);
        return updated;
    }

    @Override
    protected boolean notifyUpdate(String reason, JsonObject json) {
        this.setConnected(true);
        return this.updateType(reason, json);
    }

    protected abstract JsonObject createValueJson();

    protected abstract boolean updateFields(JsonObject var1);

    protected abstract void route(JsonObject var1, PathfinderServices var2);

    static {
        logger.setLevel(Level.INFO);
    }
}

