/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.thepathfinder.android.Model;
import xyz.thepathfinder.android.ModelType;
import xyz.thepathfinder.android.Path;

class ModelRegistry {
    private static final Logger logger = Logger.getLogger(ModelRegistry.class.getName());
    private final Map<Path, Model> models = new HashMap<Path, Model>();
    private final Queue<Model> incomingModels = new LinkedList<Model>();

    protected ModelRegistry() {
    }

    protected void registerModel(Model model) {
        if (this.models.containsKey(model.getPath())) {
            logger.severe("Illegal State Exception: path already exists" + model.getPathName());
            throw new IllegalStateException("Path already exists: " + model.getPathName());
        }
        this.models.put(model.getPath(), model);
    }

    protected Model unregisterModel(Path path) {
        return this.models.remove(path);
    }

    protected boolean isModelRegistered(Path path) {
        return this.models.containsKey(path);
    }

    protected Model getModel(Path path) {
        logger.info("Model requested: " + path.getPathName() + " Type: " + (Object)((Object)path.getModelType()));
        return this.models.get(path);
    }

    protected void addIncomingModel() {
    }

    protected Model getIncomingModel(Path parentPath, ModelType type) {
        Model model = this.incomingModels.peek();
        if (model.getParentPath().equals(parentPath) && model.getModelType().equals((Object)type)) {
            this.incomingModels.poll();
            return model;
        }
        return null;
    }

    static {
        logger.setLevel(Level.INFO);
    }
}

