/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.thepathfinder.android.ModelType;

class Path {
    private static final Logger logger = Logger.getLogger(Path.class.getName());
    private static final String PATH_SEPARATOR = "/";
    protected static final String DEFAULT_PATH = "/root";
    private String path;
    private ModelType modelType;

    protected Path(String path, ModelType modelType) {
        if (!Path.isValidPath(path)) {
            logger.severe("Illegal Argument Exception: Illegal path name " + path);
            throw new IllegalArgumentException("Illegal path name " + path);
        }
        this.path = path;
        this.modelType = modelType;
    }

    public static boolean isValidPath(String path) {
        return path != null && !path.equals("") && !path.contains(" ");
    }

    public static boolean isValidName(String name) {
        return !name.contains(PATH_SEPARATOR) && !name.equals("") && !name.contains(" ");
    }

    protected Path getChildPath(String name, ModelType type) {
        if (!this.getModelType().equals((Object)ModelType.CLUSTER) || !type.equals((Object)ModelType.CLUSTER)) {
            logger.severe("Illegal State Exception: Cannot get a child path name on a non-cluster type");
            throw new IllegalStateException("Cannot get a child path name on a non-cluster type");
        }
        if (Path.isValidName(name)) {
            return new Path(this.path + PATH_SEPARATOR + name, type);
        }
        logger.severe("Illegal Argument Exception: Illegal path name " + name);
        throw new IllegalArgumentException("Illegal path name: " + name);
    }

    public String getName() {
        int lastSlashIndex = this.path.lastIndexOf(PATH_SEPARATOR) + 1;
        return this.path.substring(lastSlashIndex);
    }

    public String getPathName() {
        return this.path;
    }

    public Path getParentPath() {
        int lastSlashIndex = this.path.lastIndexOf(PATH_SEPARATOR);
        if (lastSlashIndex == 0) {
            return null;
        }
        return new Path(this.path.substring(0, lastSlashIndex), ModelType.CLUSTER);
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public boolean equals(Object o) {
        if (o instanceof Path) {
            Path otherPath = (Path)o;
            return this.modelType == otherPath.modelType && this.path.equals(otherPath.path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    static {
        logger.setLevel(Level.INFO);
    }
}

