/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.WebSocketContainer;
import xyz.thepathfinder.android.Cluster;
import xyz.thepathfinder.android.Commodity;
import xyz.thepathfinder.android.Connection;
import xyz.thepathfinder.android.ConnectionConfiguration;
import xyz.thepathfinder.android.ModelRegistry;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.Transport;

public class Pathfinder {
    private PathfinderServices services;
    private URI webSocketUrl;
    private ConnectionConfiguration connectionConfiguration;
    private static Logger logger = Logger.getLogger(Pathfinder.class.getName());

    public Pathfinder(String applicationIdentifier, String userCredentials) {
        try {
            this.webSocketUrl = new URI("ws://api.thepathfinder.xyz/socket");
        }
        catch (URISyntaxException e) {
            logger.severe(e.getMessage());
        }
        this.constructPathfinder(applicationIdentifier, userCredentials);
    }

    protected Pathfinder(String applicationIdentifier, String userCredentials, URI webSocketUrl) {
        this.webSocketUrl = webSocketUrl;
        this.constructPathfinder(applicationIdentifier, userCredentials);
    }

    private void constructPathfinder(String applicationIdentifier, String userCredentials) {
        this.connectionConfiguration = new ConnectionConfiguration(applicationIdentifier);
        ModelRegistry registry = new ModelRegistry();
        Connection connection = new Connection(userCredentials);
        this.services = new PathfinderServices(registry, connection);
        connection.setServices(this.services);
    }

    public void connect() throws IOException, DeploymentException {
        if (!this.isConnected()) {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig configuration = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)this.connectionConfiguration).build();
            try {
                container.connectToServer((Endpoint)this.services.getConnection(), configuration, this.webSocketUrl);
            }
            catch (DeploymentException e) {
                logger.severe("Deployment Exception: " + e.getMessage());
                throw e;
            }
            catch (IOException e) {
                logger.severe("IO Exception: " + e.getMessage());
                throw e;
            }
        }
    }

    public Cluster getDefaultCluster() {
        return Cluster.getInstance("/root", this.services);
    }

    public Cluster getCluster(String path) {
        return Cluster.getInstance(path, this.services);
    }

    public Commodity getCommodity(String path) {
        return Commodity.getInstance(path, this.services);
    }

    public Transport getTransport(String path) {
        return Transport.getInstance(path, this.services);
    }

    public boolean isConnected() {
        return this.services.getConnection().isConnected();
    }

    protected long getSentMessageCount() {
        return this.services.getConnection().getSentMessageCount();
    }

    protected long getReceivedMessageCount() {
        return this.services.getConnection().getReceivedMessageCount();
    }

    public void close() throws IOException {
        CloseReason reason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Connection ended by user");
        this.close(reason);
    }

    public void close(CloseReason reason) throws IOException {
        if (this.isConnected()) {
            logger.info("Connection closed");
            this.services.getConnection().close(reason);
        }
    }

    static {
        logger.setLevel(Level.INFO);
    }
}

