/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.thepathfinder.android.Listener;
import xyz.thepathfinder.android.Model;
import xyz.thepathfinder.android.ModelType;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.SubscribableModel;

public abstract class SubscribableCrudModel<E extends Listener<? extends Model>>
extends SubscribableModel<E> {
    private static final Logger logger = Logger.getLogger(SubscribableCrudModel.class.getName());

    public SubscribableCrudModel(String path, ModelType type, PathfinderServices services) {
        super(path, type, services);
    }

    public void connect() {
        JsonObject json = this.getMessageHeader("Read");
        this.getServices().getConnection().sendMessage(json.toString());
    }

    protected void create(JsonObject value) {
        if (this.isConnected()) {
            logger.warning("Cannot create connected model " + this.getPathName() + " the model already exists, ignoring request.");
            return;
        }
        JsonObject json = this.getMessageHeader("Create");
        json.addProperty("model", value.get("model").getAsString());
        json.add("value", (JsonElement)value);
        this.getServices().getConnection().sendMessage(json.toString());
    }

    public void delete() {
        JsonObject json = this.getMessageHeader("Delete");
        this.getServices().getConnection().sendMessage(json.toString());
    }

    protected void update(JsonObject value) {
        JsonObject json = this.getMessageHeader("Update");
        json.add("value", (JsonElement)value);
        this.getServices().getConnection().sendMessage(json.toString());
    }

    static {
        logger.setLevel(Level.INFO);
    }
}

