/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.thepathfinder.android.Listener;
import xyz.thepathfinder.android.Model;
import xyz.thepathfinder.android.ModelType;
import xyz.thepathfinder.android.PathfinderServices;

public abstract class SubscribableModel<E extends Listener<? extends Model>>
extends Model<E> {
    private static final Logger logger = Logger.getLogger(SubscribableModel.class.getName());

    public SubscribableModel(String path, ModelType type, PathfinderServices services) {
        super(path, type, services);
    }

    public JsonObject getMessageHeader(String type) {
        JsonObject json = new JsonObject();
        json.addProperty("message", type);
        json.addProperty("id", this.getPathName());
        json.addProperty("model", this.getModelType().toString());
        return json;
    }

    public void subscribe() {
        JsonObject json = this.getMessageHeader("Subscribe");
        if (this.getModelType().equals((Object)ModelType.CLUSTER)) {
            json.remove("id");
            json.addProperty("model", "Vehicle");
            json.addProperty("clusterId", this.getPathName());
            this.getServices().getConnection().sendMessage(json.toString());
            json.addProperty("model", "Commodity");
        }
        this.getServices().getConnection().sendMessage(json.toString());
    }

    public void unsubscribe() {
    }

    public void routeSubscribe() {
        JsonObject json = this.getMessageHeader("RouteSubscribe");
        this.getServices().getConnection().sendMessage(json.toString());
    }

    public void routeUnsubscribe() {
    }

    static {
        logger.setLevel(Level.INFO);
    }
}

