/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.thepathfinder.android.Cluster;
import xyz.thepathfinder.android.ClusterListener;
import xyz.thepathfinder.android.ModelType;
import xyz.thepathfinder.android.Path;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.Route;
import xyz.thepathfinder.android.SubscribableCrudModel;
import xyz.thepathfinder.android.TransportListener;
import xyz.thepathfinder.android.TransportStatus;

public class Transport
extends SubscribableCrudModel<TransportListener> {
    private static final Logger logger = Logger.getLogger(Transport.class.getName());
    private double latitude;
    private double longitude;
    private TransportStatus status;
    private JsonObject metadata;
    private Route route;

    protected Transport(String path, PathfinderServices services) {
        super(path, ModelType.TRANSPORT, services);
        logger.info("Constructing transport by parameters: " + path);
        boolean isRegistered = this.getServices().getRegistry().isModelRegistered(new Path(path, ModelType.TRANSPORT));
        if (isRegistered) {
            logger.severe("Illegal Argument Exception: Transport path already exists: " + path);
            throw new IllegalArgumentException("Transport path already exists: " + path);
        }
        this.getServices().getRegistry().registerModel(this);
        this.latitude = 0.0;
        this.longitude = 0.0;
        this.status = TransportStatus.OFFLINE;
        this.metadata = new JsonObject();
        this.route = null;
    }

    protected Transport(String path, double latitude, double longitude, TransportStatus status, JsonObject metadata, PathfinderServices services) {
        this(path, services);
        this.latitude = latitude;
        this.longitude = longitude;
        this.status = status == null ? TransportStatus.OFFLINE : status;
        this.metadata = metadata == null ? new JsonObject() : metadata;
        this.route = null;
    }

    public static Transport getInstance(String path, PathfinderServices services) {
        Transport transport = (Transport)services.getRegistry().getModel(new Path(path, ModelType.TRANSPORT));
        if (transport == null && Path.isValidPath(path)) {
            return new Transport(path, services);
        }
        logger.info("Finished getting transport instance: " + transport);
        return transport;
    }

    protected static Transport getInstance(JsonObject transportJson, PathfinderServices services) {
        if (!Transport.checkTransportFields(transportJson)) {
            logger.severe("Illegal Argument Exception: Invalid JSON cannot be parsed to a transport " + transportJson);
            throw new IllegalArgumentException("Invalid JSON cannot be parsed to a transport " + transportJson);
        }
        String path = Transport.getPath(transportJson);
        Transport transport = Transport.getInstance(path, services);
        logger.info("Notifying transport of update: \nCurrent transport: " + transport + "\nNew JSON: " + transportJson);
        transport.notifyUpdate(null, transportJson);
        return transport;
    }

    private static boolean checkTransportField(JsonObject transportJson, String field) {
        return transportJson.has(field);
    }

    private static boolean checkTransportFields(JsonObject transportJson) {
        return Transport.checkTransportField(transportJson, "id") && Transport.checkTransportField(transportJson, "clusterId") && Transport.checkTransportField(transportJson, "latitude") && Transport.checkTransportField(transportJson, "longitude") && Transport.checkTransportField(transportJson, "status") && Transport.checkTransportField(transportJson, "metadata") && transportJson.get("metadata").isJsonObject();
    }

    private static String getPath(JsonObject transportJson) {
        String path = transportJson.get("clusterId").getAsString();
        return path + "/" + transportJson.get("id").getAsString();
    }

    public void updateLocation(double latitude, double longitude) {
        this.update(latitude, longitude, null, null);
    }

    public double getLatitude() {
        return this.latitude;
    }

    private void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    private void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public TransportStatus getStatus() {
        return this.status;
    }

    private void setStatus(TransportStatus status) {
        this.status = status;
    }

    private static TransportStatus getStatus(String status) {
        TransportStatus[] values;
        for (TransportStatus value : values = TransportStatus.values()) {
            if (!value.equals(status)) continue;
            return value;
        }
        return null;
    }

    public void updateStatus(TransportStatus status) {
        this.update(null, null, status, null);
    }

    public JsonObject getMetadata() {
        return this.metadata;
    }

    private void setMetadata(JsonObject metadata) {
        this.metadata = metadata == null ? new JsonObject() : metadata;
    }

    public void updateMetadata(JsonObject metadata) {
        this.update(null, null, null, metadata);
    }

    public Route getRoute() {
        return this.route;
    }

    protected void setRoute(Route route) {
        this.route = route;
    }

    public void update(Double latitude, Double longitude, TransportStatus status, JsonObject metadata) {
        JsonObject value = new JsonObject();
        if (latitude != null) {
            value.addProperty("latitude", (Number)latitude);
        }
        if (longitude != null) {
            value.addProperty("longitude", (Number)longitude);
        }
        if (status != null) {
            value.addProperty("status", status.toString());
        }
        if (metadata != null) {
            value.add("metadata", (JsonElement)metadata);
        }
        super.update(value);
    }

    @Override
    protected JsonObject createValueJson() {
        JsonObject json = new JsonObject();
        json.addProperty("clusterId", this.getPathName());
        json.addProperty("model", this.getModelType().toString());
        json.addProperty("latitude", (Number)this.getLatitude());
        json.addProperty("longitude", (Number)this.getLongitude());
        json.addProperty("status", this.getStatus().toString());
        json.add("metadata", (JsonElement)this.getMetadata());
        return json;
    }

    @Override
    protected boolean updateFields(JsonObject json) {
        boolean updated = false;
        double prevLatitude = this.getLatitude();
        if (json.has("latitude")) {
            this.setLatitude(json.get("latitude").getAsDouble());
        }
        double prevLongitude = this.getLongitude();
        if (json.has("longitude")) {
            this.setLongitude(json.get("longitude").getAsDouble());
        }
        TransportStatus prevStatus = this.getStatus();
        if (json.has("status")) {
            this.setStatus(Transport.getStatus(json.get("status").getAsString()));
        }
        JsonObject prevMetadata = this.getMetadata();
        if (json.has("metadata")) {
            this.setMetadata(json.get("metadata").getAsJsonObject());
        }
        List listeners = this.getListeners();
        if (this.getLatitude() != prevLatitude || this.getLongitude() != prevLongitude) {
            logger.info("Transport " + this.getPath() + " location updated: " + this.getLatitude() + "," + this.getLongitude());
            for (TransportListener listener : listeners) {
                listener.locationUpdated(this.getLatitude(), this.getLongitude());
            }
            updated = true;
        }
        if (this.getStatus().equals((Object)prevStatus)) {
            logger.info("Transport " + this.getPath() + " status updated: " + (Object)((Object)this.getStatus()));
            for (TransportListener listener : listeners) {
                listener.statusUpdated(this.getStatus());
            }
            updated = true;
        }
        if (this.getMetadata().equals((Object)prevMetadata)) {
            logger.info("Transport " + this.getPath() + " metadata updated: " + this.getMetadata());
            for (TransportListener listener : listeners) {
                listener.metadataUpdated(this.getMetadata());
            }
            updated = true;
        }
        Path parentPath = this.getParentPath();
        if (updated && this.getServices().getRegistry().isModelRegistered(parentPath)) {
            boolean added;
            Cluster parentCluster = Cluster.getInstance(parentPath.getPathName(), this.getServices());
            boolean bl = added = !parentCluster.getTransportsMap().containsKey(this.getPathName());
            if (added) {
                parentCluster.addTransport(this);
            }
            Collection<Transport> transports = parentCluster.getTransports();
            logger.info("Transport " + this.getPath() + " calling parent cluster's update");
            List clusterListeners = parentCluster.getListeners();
            for (ClusterListener listener : clusterListeners) {
                if (added) {
                    listener.transportAdded(this);
                }
                listener.transportUpdated(this);
                listener.transportsUpdated(transports);
            }
        }
        return updated;
    }

    @Override
    protected void route(JsonObject json, PathfinderServices services) {
        JsonObject route = json.getAsJsonObject("value");
        logger.info("Transport setting route: " + this.getPath());
        this.route = new Route(route, services);
        logger.info("Transport updating route: " + this.getPath());
        for (TransportListener listener : this.getListeners()) {
            listener.routed(this.getRoute());
        }
    }

    public String toString() {
        JsonObject json = this.createValueJson();
        if (this.route != null) {
            json.addProperty("route", this.route.toString());
        }
        return json.toString();
    }

    static {
        logger.setLevel(Level.INFO);
    }
}

